package cz.applifting.appgraph.decorations

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.DrawScope
import cz.applifting.appgraph.charts.common.BasicChartDrawer
import cz.applifting.appgraph.charts.common.drawHorizontalGridLines
import cz.applifting.appgraph.charts.utils.chartYtoCanvasY

/**
 * Component that draws horizontal grid lines to the canvas. 1 for each y-axis label.
 */
data class HorizontalGridLines(
    val color: Color = Color.LightGray,
    val heightPx: Int = 2
): CanvasDrawable {
    override fun drawToCanvas(basicChartDrawer: BasicChartDrawer) {
        basicChartDrawer.scope.drawHorizontalGridLines(
            this,
            basicChartDrawer
        )
    }
}