package cz.applifting.appgraph.decorations

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import cz.applifting.appgraph.charts.common.BasicChartDrawer
import cz.applifting.appgraph.charts.common.drawHorizontalLine

/**
 * Component that draws horizontal line to canvas.
 *
 * @property y - chart position according to current y scale.
 * @property color
 * @property widthDp
 * @property style - FULL, DASHED
 */
data class HorizontalLine(val y: Float, val color: Color, val widthDp: Dp, val style: HorizontalLineStyle = HorizontalLineStyle.FULL): CanvasDrawable {

    override fun drawToCanvas(basicChartDrawer: BasicChartDrawer) {
        basicChartDrawer.scope.drawHorizontalLine(this, basicChartDrawer)
    }
}

enum class HorizontalLineStyle { FULL, DASHED }

