package cz.applifting.appgraph.decorations

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.DrawScope
import cz.applifting.appgraph.charts.common.BasicChartDrawer
import cz.applifting.appgraph.charts.common.drawVerticalGridLines

/**
 * Component that draws vertical gridlines to the canvas. Line is drawn on each x-axis point.
 */
data class VerticalGridLines(
    val color: Color = Color.LightGray,
    val widthPx: Int = 2
): CanvasDrawable {
    override fun drawToCanvas(basicChartDrawer: BasicChartDrawer) {
        basicChartDrawer.scope.drawVerticalGridLines(
            this,
            basicChartDrawer
        )
    }
}

