package cz.applifting.firebasewrappersdk

import android.util.Log
import com.facebook.AccessToken
import com.google.firebase.auth.FacebookAuthProvider
import com.google.firebase.auth.FirebaseAuth
import com.google.firebase.auth.GoogleAuthProvider
import com.google.firebase.auth.ktx.auth
import com.google.firebase.ktx.Firebase

private const val TAG = "FirebaseAuthenticationService"

internal class FirebaseAuthenticationService {
    private var auth: FirebaseAuth = Firebase.auth

    fun firebaseAuthWithGoogle(idToken: String, onSuccess: () -> Unit, onCancel: (exceptionMsg: String?) -> Unit) {
        val credential = GoogleAuthProvider.getCredential(idToken, null)
        auth.signInWithCredential(credential)
            .addOnCompleteListener { task ->
                if (task.isSuccessful) {
                    task.result.user?.getIdToken(true)?.addOnCompleteListener {
                        if (it.isSuccessful) {
                            Log.i(TAG, "firebaseAuthWithGoogle returned token: ${maskToken(it.result.token!!)}")
                        }
                    }
                    onSuccess()
                } else {
                    onCancel.invoke(task.exception?.localizedMessage)
                }
            }
    }

    fun firebaseAuthWithFacebook(accessToken: AccessToken, onSuccess: () -> Unit, onCancel: (exceptionMsg: String?) -> Unit) {
        val credential = FacebookAuthProvider.getCredential(accessToken.token)
        auth.signInWithCredential(credential)
            .addOnCompleteListener { task ->
                if (task.isSuccessful) {
                    task.result.user?.getIdToken(true)?.addOnCompleteListener {
                        if (it.isSuccessful) {
                            Log.i(TAG, "firebaseAuthWithFacebook returned token: ${maskToken(it.result.token!!)}")
                        }
                    }
                    onSuccess()
                } else {
                    onCancel.invoke(task.exception?.localizedMessage)
                }
            }
    }

    fun singOut() = auth.signOut()

    /**
     * @return Token with all but the last four characters replaced by *
     */
    private fun maskToken(token: String): String {
        return token.replace(".(?=.{4})".toRegex(), "*")
    }
}