package cz.applifting.firebasewrappersdk

import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.os.Build
import com.facebook.AccessToken

class FirebaseServices(private val context: Context) {

    private var firebaseCloudMessagingService: FirebaseCloudMessagingService =
        FirebaseCloudMessagingService()
    private var firebaseAuthenticationService: FirebaseAuthenticationService =
        FirebaseAuthenticationService()

    init {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val notificationChannel = NotificationChannel(
                context.getString(R.string.default_notification_channel_id),
                context.getString(R.string.default_notification_channel_name),
                NotificationManager.IMPORTANCE_DEFAULT
            ).apply {
                setShowBadge(true)
            }
            val notificationManager =
                context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            notificationManager.createNotificationChannel(notificationChannel)
        }
    }

    fun createChannel(channelId: String, channelName: String, importance: Int) {
        val notificationChannel = NotificationChannel(
            channelId,
            channelName,
            importance
        ).apply {
            setShowBadge(true)
        }
        val notificationManager =
            context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        notificationManager.createNotificationChannel(notificationChannel)
    }

    fun unsubscribeFromTopic(topic: String?, myCallback: (result: String?) -> Unit) {
        firebaseCloudMessagingService.unsubscribeFromTopic(topic, myCallback)
    }

    fun subscribeToTopic(topic: String?, myCallback: (result: String?) -> Unit) {
        firebaseCloudMessagingService.subscribeToTopic(topic, myCallback)
    }

    fun firebaseAuthWithGoogle(idToken: String, onSuccess: () -> Unit, onCancel: (exceptionMsg: String?) -> Unit) {
        firebaseAuthenticationService.firebaseAuthWithGoogle(idToken, onSuccess, onCancel)
    }

    fun firebaseAuthWithFacebook(accessToken: AccessToken, onSuccess: () -> Unit, onCancel: (exceptionMsg: String?) -> Unit) {
        firebaseAuthenticationService.firebaseAuthWithFacebook(accessToken, onSuccess, onCancel)
    }

    fun singOut() = firebaseAuthenticationService.singOut()
}
