/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.cdi;

import cz.auderis.tools.config.ConfigurationData;
import cz.auderis.tools.config.ConfigurationDataProvider;
import cz.auderis.tools.config.cdi.InjectorDataProvider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;

class ConfigurationInjector
implements Bean,
Serializable {
    private static final long serialVersionUID = 7741337547728658327L;
    private static final Set<Annotation> DEFAULT_QUALIFIERS = ConfigurationInjector.createDefaultQualifiers();
    private final Class<?> targetType;
    private final Set<Annotation> qualifiers;
    private final InjectorDataProvider dataProvider;

    private static Set<Annotation> createDefaultQualifiers() {
        HashSet<AnnotationLiteral> result = new HashSet<AnnotationLiteral>(2);
        AnnotationLiteral<Default> defaultLiteral = new AnnotationLiteral<Default>(){};
        AnnotationLiteral<Any> anyLiteral = new AnnotationLiteral<Any>(){};
        result.add(defaultLiteral);
        result.add(anyLiteral);
        return Collections.unmodifiableSet(result);
    }

    ConfigurationInjector(Class<?> type, Set<Annotation> qualifiers, InjectorDataProvider cdiDataProvider) {
        assert (null != type);
        assert (null != cdiDataProvider);
        this.targetType = type;
        this.dataProvider = cdiDataProvider;
        if (qualifiers == null || qualifiers.isEmpty()) {
            this.qualifiers = DEFAULT_QUALIFIERS;
        } else {
            HashSet<Annotation> copyOfQualifiers = new HashSet<Annotation>(qualifiers);
            this.qualifiers = Collections.unmodifiableSet(copyOfQualifiers);
        }
    }

    public Set<? extends Type> getTypes() {
        return Collections.singleton(this.targetType);
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<?> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set getStereotypes() {
        return Collections.emptySet();
    }

    public Class getBeanClass() {
        return this.targetType;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Set getInjectionPoints() {
        return Collections.emptySet();
    }

    public Object create(CreationalContext creationalContext) {
        Object cfgAccessor = ConfigurationData.createConfigurationObject((ConfigurationDataProvider)this.dataProvider, this.targetType);
        return cfgAccessor;
    }

    public void destroy(Object instance, CreationalContext creationalContext) {
        creationalContext.release();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(32);
        str.append("CfgInjector[class=");
        str.append(this.targetType);
        if (!this.qualifiers.isEmpty()) {
            str.append(", qualifiers=");
            str.append(this.qualifiers);
        }
        str.append(']');
        return str.toString();
    }
}

