/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.cdi;

import cz.auderis.tools.config.ConfigurationDataProvider;
import cz.auderis.tools.config.annotation.ConfigurationObject;
import cz.auderis.tools.config.cdi.ConfigurationInjector;
import cz.auderis.tools.config.cdi.ConfigurationObjectKey;
import cz.auderis.tools.config.cdi.ConfigurationSource;
import cz.auderis.tools.config.cdi.ConfigurationSourceComparator;
import cz.auderis.tools.config.cdi.InjectorDataProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInjectorExtension
implements Extension {
    final Logger LOG;
    int detectedInjectionPoints;
    final Set<ConfigurationObjectKey> cfgObjectInjections = new HashSet<ConfigurationObjectKey>(32);
    final InjectorDataProvider cdiDataProvider = new InjectorDataProvider();

    public ConfigurationInjectorExtension() {
        this.LOG = LoggerFactory.getLogger(ConfigurationInjectorExtension.class);
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        this.LOG.debug("Auderis Configuration CDI extension enabled");
        event.addQualifier(ConfigurationObject.class);
    }

    public <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> event, BeanManager beanManager) {
        boolean logInjectionPoints = this.LOG.isTraceEnabled();
        InjectionTarget injectionTarget = event.getInjectionTarget();
        Set injectionPoints = injectionTarget.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            Annotated annotatedPoint = injectionPoint.getAnnotated();
            if (!annotatedPoint.isAnnotationPresent(ConfigurationObject.class)) continue;
            this.registerCfgObjectInjectionPoint(injectionPoint, beanManager);
            if (!logInjectionPoints) continue;
            this.LOG.trace("Registered " + injectionPoint + " as configuration injection point");
        }
    }

    private void registerCfgObjectInjectionPoint(InjectionPoint injectionPoint, BeanManager beanManager) {
        Class pointType = (Class)injectionPoint.getAnnotated().getBaseType();
        Set origAnnotations = injectionPoint.getAnnotated().getAnnotations();
        HashSet<Annotation> pointAnnotations = new HashSet<Annotation>(origAnnotations);
        Iterator annotationIterator = pointAnnotations.iterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (beanManager.isQualifier(annotationType)) continue;
            annotationIterator.remove();
        }
        ConfigurationObjectKey injection = new ConfigurationObjectKey(pointType, pointAnnotations);
        this.cfgObjectInjections.add(injection);
        ++this.detectedInjectionPoints;
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        if (this.cfgObjectInjections.isEmpty()) {
            this.LOG.debug("No configuration injection points detected");
            return;
        }
        List<ConfigurationDataProvider> cfgDataProviders = this.getAvailableProviders(manager);
        this.LOG.trace("Detected " + cfgDataProviders.size() + " configuration data providers");
        if (cfgDataProviders.isEmpty()) {
            int injectCount = this.cfgObjectInjections.size();
            this.LOG.error("Cannot inject " + injectCount + " cfg injection points, no data providers detected");
            throw new InjectionException("Cannot create configuration data provider, no @ConfigurationSource found");
        }
        for (ConfigurationDataProvider provider : cfgDataProviders) {
            this.cdiDataProvider.addDelegate(provider);
        }
        this.LOG.trace("Preparing beans for " + this.cfgObjectInjections.size() + " requested configuration data types");
        for (ConfigurationObjectKey key : this.cfgObjectInjections) {
            Class<?> cfgBeanType = key.getType();
            Set<Annotation> qualifiers = key.getQualifiers();
            ConfigurationInjector bean = new ConfigurationInjector(cfgBeanType, qualifiers, this.cdiDataProvider);
            event.addBean((Bean)bean);
        }
        this.LOG.debug("Prepared " + this.cfgObjectInjections.size() + " beans for " + this.detectedInjectionPoints + " configuration injection points");
        this.detectedInjectionPoints = 0;
        this.cfgObjectInjections.clear();
    }

    private List<ConfigurationDataProvider> getAvailableProviders(BeanManager beanManager) {
        assert (beanManager.isQualifier(ConfigurationSource.class));
        AnnotationLiteral<Any> anyAnnotation = new AnnotationLiteral<Any>(){};
        Set cfgBeanCandidates = beanManager.getBeans(ConfigurationDataProvider.class, new Annotation[]{anyAnnotation});
        if (cfgBeanCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        int candidateCount = cfgBeanCandidates.size();
        ArrayList<Bean> candidateList = new ArrayList<Bean>(candidateCount);
        for (Bean candidateBean : cfgBeanCandidates) {
            if (!ConfigurationInjectorExtension.hasQualifierType(candidateBean, ConfigurationSource.class)) continue;
            assert (ConfigurationInjectorExtension.hasBeanType(candidateBean, ConfigurationDataProvider.class));
            candidateList.add(candidateBean);
        }
        if (candidateList.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(candidateList, ConfigurationSourceComparator.BY_PRIORITY);
        ArrayList<ConfigurationDataProvider> result = new ArrayList<ConfigurationDataProvider>(candidateList.size());
        CreationalContext ctx = beanManager.createCreationalContext(null);
        for (Bean candidateBean : candidateList) {
            ConfigurationDataProvider instance = (ConfigurationDataProvider)candidateBean.create(ctx);
            result.add(instance);
        }
        return result;
    }

    private static boolean hasQualifierType(Bean<?> bean, Class<? extends Annotation> requiredType) {
        Set qualifiers = bean.getQualifiers();
        if (null == qualifiers) {
            return false;
        }
        for (Annotation qualifier : qualifiers) {
            Class<? extends Annotation> qualifierType = qualifier.annotationType();
            if (!requiredType.equals(qualifierType)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBeanType(Bean<?> bean, Class<?> requiredType) {
        Set types = bean.getTypes();
        for (Type type : types) {
            if (!(type instanceof Class) || !requiredType.isAssignableFrom((Class)type)) continue;
            return true;
        }
        return false;
    }
}

