/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.cdi;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class ConfigurationObjectKey {
    final Class<?> type;
    final Set<Annotation> qualifiers;

    ConfigurationObjectKey(Class<?> type, Set<Annotation> qualifiers) {
        assert (null != type);
        assert (null != qualifiers);
        this.type = type;
        if (qualifiers.isEmpty()) {
            this.qualifiers = Collections.emptySet();
        } else {
            HashSet<Annotation> qualifiersCopy = new HashSet<Annotation>(qualifiers);
            this.qualifiers = Collections.unmodifiableSet(qualifiersCopy);
        }
    }

    Class<?> getType() {
        return this.type;
    }

    Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public int hashCode() {
        int result = this.qualifiers.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationObjectKey other = (ConfigurationObjectKey)obj;
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.qualifiers.equals(other.qualifiers);
    }

    public String toString() {
        return "CfgObjKey[class=" + this.type + ", qualifiers=" + this.qualifiers + ']';
    }
}

