/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.cdi;

import cz.auderis.tools.config.ConfigurationDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class InjectorDataProvider
implements ConfigurationDataProvider {
    private final List<ConfigurationDataProvider> delegateProviders = new ArrayList<ConfigurationDataProvider>(64);
    private final Map<String, ConfigurationDataProvider> providerByKey = new HashMap<String, ConfigurationDataProvider>(64);

    InjectorDataProvider() {
    }

    void addDelegate(ConfigurationDataProvider provider) {
        assert (null != provider);
        if (!this.delegateProviders.contains(provider)) {
            this.delegateProviders.add(provider);
            this.providerByKey.clear();
        }
    }

    public boolean containsKey(String key) {
        ConfigurationDataProvider cachedProvider = this.providerByKey.get(key);
        if (null != cachedProvider && DummyProvider.INSTANCE != cachedProvider) {
            return true;
        }
        for (ConfigurationDataProvider provider : this.delegateProviders) {
            if (!provider.containsKey(key)) continue;
            this.providerByKey.put(key, provider);
            return true;
        }
        this.providerByKey.put(key, DummyProvider.INSTANCE);
        return false;
    }

    public Object getRawObject(String key) {
        ConfigurationDataProvider cachedProvider = this.providerByKey.get(key);
        if (null != cachedProvider && DummyProvider.INSTANCE != cachedProvider) {
            return cachedProvider.getRawObject(key);
        }
        for (ConfigurationDataProvider provider : this.delegateProviders) {
            if (!provider.containsKey(key)) continue;
            this.providerByKey.put(key, provider);
            return provider.getRawObject(key);
        }
        this.providerByKey.put(key, DummyProvider.INSTANCE);
        return null;
    }

    static enum DummyProvider implements ConfigurationDataProvider
    {
        INSTANCE{

            public boolean containsKey(String key) {
                return false;
            }

            public Object getRawObject(String key) {
                return null;
            }
        };

    }
}

