/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config;

import cz.auderis.tools.config.ConfigurationDataException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StandardJavaTranslator {
    private static final StandardJavaTranslator INSTANCE = new StandardJavaTranslator();
    private final Map<Class<?>, PrimitiveTranslator> primitiveTranslatorMap = new HashMap();
    private final Map<Class<?>, Class<?>> primitiveToBoxedMap = new HashMap();
    private final Map<Class<?>, Class<?>> boxedToPrimitiveMap = new HashMap();

    public static StandardJavaTranslator instance() {
        return INSTANCE;
    }

    public boolean isPrimitiveOrBoxed(Class<?> targetType) {
        assert (null != targetType);
        return this.primitiveTranslatorMap.containsKey(targetType);
    }

    public boolean isPrimitiveOrBoxedIntegerType(Class<?> targetType) {
        assert (null != targetType);
        PrimitiveTranslator translator = this.primitiveTranslatorMap.get(targetType);
        return null != translator && translator.isInteger();
    }

    public boolean isPrimitiveOrBoxedFloatType(Class<?> targetType) {
        assert (null != targetType);
        PrimitiveTranslator translator = this.primitiveTranslatorMap.get(targetType);
        return null != translator && !translator.isInteger();
    }

    public Class<?> switchPrimitiveAndBoxedType(Class<?> type) {
        assert (null != type);
        if (type.isPrimitive()) {
            return this.primitiveToBoxedMap.get(type);
        }
        return this.boxedToPrimitiveMap.get(type);
    }

    public Object translatePrimitive(Object source, Class<?> returnType, boolean strict) {
        PrimitiveTranslator translator;
        block8: {
            assert (null != returnType);
            translator = this.primitiveTranslatorMap.get(returnType);
            assert (null != translator);
            if (null == source) {
                return translator.defaultValue(returnType);
            }
            if (translator.getSupportedClasses().contains(source.getClass())) {
                return source;
            }
            if (source instanceof Number) {
                return translator.convertNumber((Number)source);
            }
            if (source instanceof String) {
                String primitiveStr = ((String)source).trim();
                try {
                    return translator.translateString(primitiveStr);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block8;
                    throw new ConfigurationDataException("cannot parse value '" + primitiveStr + "' into type " + returnType.getClass().getName(), e);
                }
            }
        }
        return translator.defaultValue(returnType);
    }

    public Object translateEnum(Object sourceValue, Class<?> returnType, boolean strict) {
        assert (null != returnType && returnType.isEnum());
        if (null == sourceValue) {
            return null;
        }
        if (returnType.isAssignableFrom(sourceValue.getClass())) {
            return sourceValue;
        }
        if (!(sourceValue instanceof String)) {
            if (strict) {
                throw new ConfigurationDataException("cannot transform type " + sourceValue.getClass().getName() + " into enum " + returnType.getName());
            }
            return null;
        }
        String enumName = ((String)sourceValue).trim();
        if (enumName.isEmpty()) {
            return null;
        }
        for (Object enumObj : returnType.getEnumConstants()) {
            Enum enumConst = (Enum)enumObj;
            if (!enumName.equalsIgnoreCase(enumConst.name())) continue;
            return enumConst;
        }
        if (strict) {
            throw new ConfigurationDataException("cannot find identifier '" + enumName + "' in enum " + returnType.getName());
        }
        return null;
    }

    private StandardJavaTranslator() {
        for (PrimitiveTranslator tx : PrimitiveTranslator.values()) {
            List<Class<?>> supportedClasses = tx.getSupportedClasses();
            for (Class<?> supportedClass : supportedClasses) {
                this.primitiveTranslatorMap.put(supportedClass, tx);
            }
            Class<?> primitiveType = supportedClasses.get(1);
            Class<?> boxedType = supportedClasses.get(0);
            this.primitiveToBoxedMap.put(primitiveType, boxedType);
            this.boxedToPrimitiveMap.put(boxedType, primitiveType);
        }
    }

    static enum PrimitiveTranslator {
        BOOLEAN{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Boolean.class, Boolean.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Boolean.parseBoolean(source);
            }

            @Override
            public Object convertNumber(Number num) {
                return 0 != num.intValue();
            }

            @Override
            public Object defaultValue() {
                return false;
            }

            @Override
            public boolean isInteger() {
                return false;
            }
        }
        ,
        BYTE{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Byte.class, Byte.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Byte.parseByte(source);
            }

            @Override
            public Object convertNumber(Number num) {
                return num.byteValue();
            }

            @Override
            public Object defaultValue() {
                return (byte)0;
            }
        }
        ,
        SHORT{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Short.class, Short.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Short.parseShort(source);
            }

            @Override
            public Object convertNumber(Number num) {
                return num.shortValue();
            }

            @Override
            public Object defaultValue() {
                return (short)0;
            }
        }
        ,
        INT{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Integer.class, Integer.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Integer.parseInt(source);
            }

            @Override
            public Object convertNumber(Number num) {
                return num.intValue();
            }

            @Override
            public Object defaultValue() {
                return 0;
            }
        }
        ,
        LONG{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Long.class, Long.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Long.parseLong(source);
            }

            @Override
            public Object convertNumber(Number num) {
                return num.longValue();
            }

            @Override
            public Object defaultValue() {
                return 0L;
            }
        }
        ,
        FLOAT{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Float.class, Float.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Float.valueOf(Float.parseFloat(source));
            }

            @Override
            public Object convertNumber(Number num) {
                return Float.valueOf(num.floatValue());
            }

            @Override
            public Object defaultValue() {
                return Float.valueOf(0.0f);
            }

            @Override
            public boolean isInteger() {
                return false;
            }
        }
        ,
        DOUBLE{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Double.class, Double.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Double.parseDouble(source);
            }

            @Override
            public Object convertNumber(Number num) {
                return num.doubleValue();
            }

            @Override
            public Object defaultValue() {
                return 0.0;
            }

            @Override
            public boolean isInteger() {
                return false;
            }
        };


        public abstract List<Class<?>> getSupportedClasses();

        public abstract Object defaultValue();

        public Object defaultValue(Class<?> resultType) {
            return resultType.isPrimitive() ? this.defaultValue() : null;
        }

        public abstract Object translateString(String var1);

        public abstract Object convertNumber(Number var1);

        public boolean isInteger() {
            return true;
        }
    }
}

