/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.ConfigurationDataProvider;
import java.util.Arrays;

public class CompoundDataProvider
implements ConfigurationDataProvider {
    private final ConfigurationDataProvider[] delegates;

    public CompoundDataProvider(ConfigurationDataProvider ... providers) {
        if (null == providers) {
            throw new NullPointerException();
        }
        if (0 == providers.length) {
            throw new IllegalArgumentException("no providers were specified");
        }
        for (ConfigurationDataProvider p : providers) {
            if (null != p) continue;
            throw new IllegalArgumentException("null provider specified");
        }
        this.delegates = Arrays.copyOf(providers, providers.length);
    }

    @Override
    public boolean containsKey(String key) {
        if (null == key) {
            throw new NullPointerException();
        }
        for (ConfigurationDataProvider delegate : this.delegates) {
            if (!delegate.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getRawObject(String key) {
        if (null == key) {
            throw new NullPointerException();
        }
        for (ConfigurationDataProvider delegate : this.delegates) {
            if (!delegate.containsKey(key)) continue;
            return delegate.getRawObject(key);
        }
        return null;
    }
}

