/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config;

import cz.auderis.tools.config.ConfigurationDataProvider;
import cz.auderis.tools.config.DataTranslator;
import cz.auderis.tools.config.DataTranslatorContext;
import cz.auderis.tools.config.StandardJavaTranslator;
import cz.auderis.tools.config.annotation.ConfigurationEntries;
import cz.auderis.tools.config.annotation.ConfigurationEntry;
import cz.auderis.tools.config.annotation.DefaultConfigurationEntryValue;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ConfigurationDataAccessProxyHandler
implements InvocationHandler {
    private static final String GETTER_PREFIX = "get";
    private static final String GETTER_PREFIX_BOOLEAN = "is";
    private static final Object NULL_CACHE_ENTRY = new Object();
    private final ConfigurationDataProvider dataProvider;
    private final ConcurrentMap<Method, SoftReference<Object>> cache;
    private final ConcurrentMap<Method, TranslationPhase> successfulPhase;
    private final boolean strictMode;

    ConfigurationDataAccessProxyHandler(ConfigurationDataProvider dataProvider, boolean strictMode) {
        assert (null != dataProvider);
        this.dataProvider = dataProvider;
        this.cache = new ConcurrentHashMap<Method, SoftReference<Object>>(64);
        this.successfulPhase = new ConcurrentHashMap<Method, TranslationPhase>(64);
        this.strictMode = strictMode;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        assert (null == args || 0 != args.length);
        if (null == args) {
            if (TranslationPhase.NONE == this.successfulPhase.get(method)) {
                return null;
            }
            SoftReference cachedValueRef = (SoftReference)this.cache.get(method);
            if (null != cachedValueRef) {
                Object cachedValue = cachedValueRef.get();
                if (NULL_CACHE_ENTRY == cachedValue) {
                    return null;
                }
                if (null != cachedValue) {
                    return cachedValue;
                }
                this.cache.remove(method, cachedValueRef);
            }
        }
        String keyName = this.getResourceKey(method);
        assert (null != keyName);
        Object sourceValue = this.dataProvider.containsKey(keyName) ? this.dataProvider.getRawObject(keyName) : this.getDefaultSourceValue(method);
        Object result = this.translateObject(sourceValue, method, args);
        if (null == args) {
            if (null == result) {
                this.successfulPhase.putIfAbsent(method, TranslationPhase.NONE);
            }
            Object cachedValue = null != result ? result : NULL_CACHE_ENTRY;
            this.cache.put(method, new SoftReference<Object>(cachedValue));
        }
        return result;
    }

    private Object getDefaultSourceValue(Method method) {
        String result;
        DefaultConfigurationEntryValue defaultValAnnotation = method.getAnnotation(DefaultConfigurationEntryValue.class);
        String string = result = null != defaultValAnnotation ? defaultValAnnotation.value() : null;
        if (null != result && result.isEmpty()) {
            result = null;
        }
        return result;
    }

    private Object translateObject(Object sourceValue, Method method, Object[] args) {
        Object constructedResult;
        Object pluginResult;
        Class<?> returnType = method.getReturnType();
        Set<TranslationPhase> remainingPhases = this.computeRemainingPhases(method);
        if (remainingPhases.contains((Object)TranslationPhase.PARSE_STRING) && String.class.isAssignableFrom(returnType)) {
            String textResult = this.translateToString(sourceValue, args);
            this.successfulPhase.put(method, TranslationPhase.PARSE_STRING);
            return textResult;
        }
        StandardJavaTranslator stdTranslator = StandardJavaTranslator.instance();
        if (remainingPhases.contains((Object)TranslationPhase.PARSE_ENUM) && returnType.isEnum()) {
            Object enumResult = stdTranslator.translateEnum(sourceValue, returnType, this.strictMode);
            this.successfulPhase.put(method, TranslationPhase.PARSE_ENUM);
            return enumResult;
        }
        if (remainingPhases.contains((Object)TranslationPhase.PARSE_PRIMITIVE) && stdTranslator.isPrimitiveOrBoxed(returnType)) {
            Object primitiveResult = stdTranslator.translatePrimitive(sourceValue, returnType, this.strictMode);
            this.successfulPhase.put(method, TranslationPhase.PARSE_PRIMITIVE);
            return primitiveResult;
        }
        if (remainingPhases.contains((Object)TranslationPhase.APPLY_PLUGIN) && null != (pluginResult = this.tryPluginTranslator(sourceValue, returnType, method, args))) {
            this.successfulPhase.put(method, TranslationPhase.APPLY_PLUGIN);
            return DataTranslator.NULL_OBJECT != pluginResult ? pluginResult : null;
        }
        if (remainingPhases.contains((Object)TranslationPhase.CONSTRUCT_INSTANCE) && null != (constructedResult = this.tryConstruct(sourceValue, returnType, args))) {
            this.successfulPhase.put(method, TranslationPhase.CONSTRUCT_INSTANCE);
            return constructedResult;
        }
        return null;
    }

    private Set<TranslationPhase> computeRemainingPhases(Method method) {
        TranslationPhase phase = (TranslationPhase)((Object)this.successfulPhase.get(method));
        if (null == phase) {
            return EnumSet.allOf(TranslationPhase.class);
        }
        return EnumSet.range(phase, TranslationPhase.NONE);
    }

    private String translateToString(Object sourceValue, Object[] args) {
        if (null == sourceValue) {
            return "";
        }
        if (sourceValue instanceof String) {
            if (null != args) {
                try {
                    return MessageFormat.format((String)sourceValue, args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (String)sourceValue;
        }
        return sourceValue.toString();
    }

    private Object tryPluginTranslator(Object sourceValue, Class targetClass, AnnotatedElement element, Object[] args) {
        ServiceLoader<DataTranslator> translators = ServiceLoader.load(DataTranslator.class);
        Iterator<DataTranslator> translatorIterator = translators.iterator();
        ArrayList<TranslatorCandidate> applicableTranslators = new ArrayList<TranslatorCandidate>(2);
        DataTranslatorContextImpl context = new DataTranslatorContextImpl(element, args, this.strictMode);
        while (true) {
            boolean hasNext;
            try {
                hasNext = translatorIterator.hasNext();
            }
            catch (ServiceConfigurationError e) {
                hasNext = false;
            }
            if (!hasNext) break;
            try {
                DataTranslator translator = translatorIterator.next();
                int supportPriority = translator.getTargetClassSupportPriority(targetClass, context);
                if (supportPriority <= 0) continue;
                TranslatorCandidate candidate = new TranslatorCandidate(translator, supportPriority);
                applicableTranslators.add(candidate);
            }
            catch (Exception e) {}
        }
        if (!applicableTranslators.isEmpty()) {
            Collections.sort(applicableTranslators);
            for (TranslatorCandidate candidate : applicableTranslators) {
                try {
                    DataTranslator selectedTranslator = candidate.translator;
                    Object result = selectedTranslator.translateToClass(sourceValue, targetClass, context);
                    if (null == result) continue;
                    return result;
                }
                catch (Exception e) {
                }
            }
        }
        return null;
    }

    private Object tryConstruct(Object sourceValue, Class<?> returnType, Object[] args) {
        if (null == sourceValue) {
            return null;
        }
        try {
            Constructor<?>[] constructors;
            if (null == args) {
                Object[] paramRef = new Object[]{sourceValue};
                Constructor<?> constructor = this.findSingleArgumentConstructor(returnType, paramRef);
                if (null == constructor) {
                    return null;
                }
                Object result = constructor.newInstance(paramRef[0]);
                return result;
            }
            Class[] argumentTypes = new Class[1 + args.length];
            argumentTypes[0] = sourceValue.getClass();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Class<?> argClass = null == arg ? null : arg.getClass();
                argumentTypes[i + 1] = argClass;
            }
            for (Constructor<?> constructor : constructors = returnType.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                boolean paramMatch = this.matchParameters(parameterTypes, argumentTypes);
                if (!paramMatch) continue;
                Object[] extArgs = new Object[1 + args.length];
                extArgs[0] = sourceValue;
                for (int i = 0; i < args.length; ++i) {
                    extArgs[i + 1] = args[0];
                }
                Object result = constructor.newInstance(extArgs);
                return result;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private Constructor<?> findSingleArgumentConstructor(Class<?> type, Object[] paramRef) {
        Object param = paramRef[0];
        assert (null != param);
        Class<?> paramClass = param.getClass();
        try {
            Constructor<?> constructor = type.getConstructor(paramClass);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            StandardJavaTranslator stdTranslator = StandardJavaTranslator.instance();
            Class<?> altParamClass = stdTranslator.switchPrimitiveAndBoxedType(paramClass);
            if (null != altParamClass) {
                try {
                    Constructor<?> constructor = type.getConstructor(altParamClass);
                    return constructor;
                }
                catch (NoSuchMethodException e2) {
                    // empty catch block
                }
            }
            if (String.class == paramClass) {
                String textParam = (String)param;
                for (Constructor<?> candidate : type.getConstructors()) {
                    Object convertedParam;
                    Class<?>[] candidateArgTypes = candidate.getParameterTypes();
                    if (1 != candidateArgTypes.length) continue;
                    Class<?> argType = candidateArgTypes[0];
                    assert (null != argType);
                    if (!stdTranslator.isPrimitiveOrBoxed(argType) || null == (convertedParam = stdTranslator.translatePrimitive(textParam, argType, false))) continue;
                    paramRef[0] = convertedParam;
                    return candidate;
                }
            }
            return null;
        }
    }

    private boolean matchParameters(Class<?>[] parameterTypes, Class[] argumentTypes) {
        if (parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            Class argType = argumentTypes[i];
            if (!(null == argType ? paramType.isPrimitive() : !paramType.isAssignableFrom(argType))) continue;
            return false;
        }
        return true;
    }

    private String getResourceKey(Method method) {
        String keyPrefix = this.getResourceKeyPrefix(method);
        ConfigurationEntry nameAnnotation = method.getAnnotation(ConfigurationEntry.class);
        if (null != nameAnnotation) {
            boolean keyNameDefined;
            String keyName = nameAnnotation.name();
            boolean bl = keyNameDefined = null != keyName && !keyName.isEmpty();
            if (keyNameDefined && this.dataProvider.containsKey(keyPrefix + keyName)) {
                return keyPrefix + keyName;
            }
            String[] keyAliases = nameAnnotation.alias();
            if (null != keyAliases && 0 != keyAliases.length) {
                for (String alias : keyAliases) {
                    if (null == alias || alias.trim().isEmpty()) continue;
                    int firstDotIndex = alias.indexOf(46);
                    if (0 == firstDotIndex) {
                        String qualifiedAlias = alias.substring(1);
                        if (!this.dataProvider.containsKey(qualifiedAlias)) continue;
                        return qualifiedAlias;
                    }
                    if (this.dataProvider.containsKey(keyPrefix + alias)) {
                        return keyPrefix + alias;
                    }
                    if (-1 == firstDotIndex || !this.dataProvider.containsKey(alias)) continue;
                    return alias;
                }
            }
            if (keyNameDefined) {
                return keyPrefix + keyName;
            }
        }
        String methodName = method.getName();
        boolean booleanGetter = this.isBasicBooleanGetter(method);
        String keyName = this.trimOptionalGetterPrefix(methodName, booleanGetter);
        return keyPrefix + keyName;
    }

    private String getResourceKeyPrefix(Member method) {
        Class<?> declaringClass = method.getDeclaringClass();
        ConfigurationEntries prefixAnnotation = declaringClass.getAnnotation(ConfigurationEntries.class);
        if (null == prefixAnnotation) {
            return "";
        }
        String explicitPrefix = prefixAnnotation.prefix();
        if (null == explicitPrefix || explicitPrefix.trim().isEmpty()) {
            return "";
        }
        StringBuilder resultPrefix = new StringBuilder();
        if ("*".equals(explicitPrefix)) {
            resultPrefix.append(declaringClass.getSimpleName());
        } else {
            resultPrefix.append(explicitPrefix);
        }
        if (resultPrefix.charAt(resultPrefix.length() - 1) != '.') {
            resultPrefix.append('.');
        }
        return resultPrefix.toString();
    }

    private String trimOptionalGetterPrefix(String methodName, boolean considerBooleanPrefix) {
        String prefix;
        if (methodName.startsWith(GETTER_PREFIX)) {
            prefix = GETTER_PREFIX;
        } else if (considerBooleanPrefix && methodName.startsWith(GETTER_PREFIX_BOOLEAN)) {
            prefix = GETTER_PREFIX_BOOLEAN;
        } else {
            return methodName;
        }
        String propertyName = methodName.substring(prefix.length());
        char firstChar = propertyName.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return methodName;
        }
        return Character.toLowerCase(firstChar) + propertyName.substring(1);
    }

    private boolean isBasicBooleanGetter(Method method) {
        Class<?> resultType = method.getReturnType();
        if (Boolean.TYPE != resultType) {
            return false;
        }
        return 0 == method.getParameterTypes().length;
    }

    static enum TranslationPhase {
        PARSE_STRING,
        PARSE_ENUM,
        PARSE_PRIMITIVE,
        APPLY_PLUGIN,
        CONSTRUCT_INSTANCE,
        NONE;

    }

    static final class DataTranslatorContextImpl
    implements DataTranslatorContext {
        private final AnnotatedElement element;
        private final Object[] arguments;
        private final boolean strictMode;

        DataTranslatorContextImpl(AnnotatedElement element, Object[] arguments, boolean strictMode) {
            this.element = element;
            this.arguments = arguments;
            this.strictMode = strictMode;
        }

        @Override
        public AnnotatedElement getTargetElement() {
            return this.element;
        }

        @Override
        public Object[] getTargetArguments() {
            return this.arguments;
        }

        @Override
        public boolean isStrictModeEnabled() {
            return this.strictMode;
        }
    }

    static final class TranslatorCandidate
    implements Comparable<TranslatorCandidate> {
        final DataTranslator translator;
        final int priority;

        TranslatorCandidate(DataTranslator translator, int priority) {
            this.translator = translator;
            this.priority = priority;
        }

        @Override
        public int compareTo(TranslatorCandidate other) {
            return other.priority - this.priority;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || this.getClass() != obj.getClass()) {
                return false;
            }
            TranslatorCandidate other = (TranslatorCandidate)obj;
            return this.priority == other.priority && this.translator.equals(other.translator);
        }

        public int hashCode() {
            return this.priority;
        }
    }
}

