/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.DataTranslatorContext;
import cz.auderis.tools.config.StandardJavaTranslator;
import cz.auderis.tools.config.spi.SingleTargetClassTranslator;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalTranslator
extends SingleTargetClassTranslator {
    public BigDecimalTranslator() {
        super(BigDecimal.class);
    }

    @Override
    public String getId() {
        return "BigDecimal translator";
    }

    @Override
    protected Object translate(Object source, DataTranslatorContext context) {
        if (source instanceof BigInteger) {
            return new BigDecimal((BigInteger)source);
        }
        if (source instanceof Number) {
            Number numSource = (Number)source;
            if (StandardJavaTranslator.instance().isPrimitiveOrBoxedFloatType(numSource.getClass())) {
                return BigDecimal.valueOf(numSource.doubleValue());
            }
            return BigDecimal.valueOf(numSource.longValue());
        }
        if (source instanceof String) {
            try {
                return new BigDecimal((String)source);
            }
            catch (NumberFormatException e) {
            }
        } else if (source instanceof char[]) {
            char[] sourceChars = (char[])source;
            try {
                return new BigDecimal(sourceChars);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }
}

