/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.DataTranslatorContext;
import cz.auderis.tools.config.spi.SingleTargetClassTranslator;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegerTranslator
extends SingleTargetClassTranslator {
    public BigIntegerTranslator() {
        super(BigInteger.class);
    }

    @Override
    public String getId() {
        return "BigInteger translator";
    }

    @Override
    protected Object translate(Object source, DataTranslatorContext context) {
        byte[] sourceBytes;
        if (source instanceof BigDecimal) {
            return null;
        }
        if (source instanceof Number) {
            long longVal = ((Number)source).longValue();
            return BigInteger.valueOf(longVal);
        }
        if (source instanceof String) {
            try {
                return new BigInteger((String)source);
            }
            catch (NumberFormatException e) {
            }
        } else if (source instanceof byte[] && 0 != (sourceBytes = (byte[])source).length) {
            return new BigInteger(sourceBytes);
        }
        return null;
    }
}

