/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.ConfigurationDataException;
import cz.auderis.tools.config.DataTranslator;
import cz.auderis.tools.config.DataTranslatorContext;
import cz.auderis.tools.config.annotation.ConfigurationEntry;
import cz.auderis.tools.config.spi.SimpleKeyNormalizingMap;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class EnumSetTranslator
implements DataTranslator {
    private static final String ENUM_ID_SEPARATOR_CHARS = ",;: \t\r\n";

    @Override
    public String getId() {
        return "enum set translator";
    }

    @Override
    public int getTargetClassSupportPriority(Class<?> targetClass, DataTranslatorContext context) {
        if (!targetClass.isAssignableFrom(EnumSet.class)) {
            return 0;
        }
        Class<? extends Enum<?>> enumClass = this.getTargetEnumClass(context);
        if (null == enumClass) {
            return 0;
        }
        return 10;
    }

    @Override
    public Object translateToClass(Object source, Class<?> targetClass, DataTranslatorContext context) {
        if (!targetClass.isAssignableFrom(EnumSet.class)) {
            return null;
        }
        Class<Enum<?>> enumClass = this.getTargetEnumClass(context);
        if (enumClass == null) {
            return null;
        }
        if (null == source) {
            return EnumSetTranslator.createEmptyEnumSet(enumClass);
        }
        Class<?> sourceClass = source.getClass();
        if (Collection.class.isAssignableFrom(sourceClass)) {
            Collection srcCollection = (Collection)source;
            return this.translateSourceCollection(enumClass, srcCollection);
        }
        if (enumClass.equals(sourceClass)) {
            Set<?> result = EnumSetTranslator.createEmptyEnumSet(enumClass);
            result.add(enumClass.cast(source));
            return result;
        }
        if (String.class.isAssignableFrom(sourceClass)) {
            String srcText = (String)source;
            return this.translateSourceText(enumClass, srcText);
        }
        return null;
    }

    private Class<? extends Enum<?>> getTargetEnumClass(DataTranslatorContext context) {
        AnnotatedElement targetElement = context.getTargetElement();
        ConfigurationEntry entryAnnotation = targetElement.getAnnotation(ConfigurationEntry.class);
        if (null == entryAnnotation) {
            return null;
        }
        Class<?> itemClass = entryAnnotation.collectionItemType();
        if (null == itemClass || !itemClass.isEnum()) {
            return null;
        }
        Class<?> enumClass = itemClass;
        return enumClass;
    }

    public String toString() {
        return this.getId();
    }

    private Object translateSourceText(Class<? extends Enum<?>> enumClass, String srcText) {
        Set<?> result = EnumSetTranslator.createEmptyEnumSet(enumClass);
        Map<String, Enum<?>> enumConstantById = null;
        StringTokenizer parser = new StringTokenizer(srcText, ENUM_ID_SEPARATOR_CHARS);
        while (parser.hasMoreTokens()) {
            Enum<?> enumItem;
            String enumId = parser.nextToken();
            assert (null != enumId && !enumId.trim().isEmpty());
            if (null == enumConstantById) {
                enumConstantById = EnumSetTranslator.createEnumIdMap(enumClass);
            }
            if (null == (enumItem = enumConstantById.get(enumId))) {
                throw new ConfigurationDataException("invalid enum name '" + enumId + "' for enum set of type " + enumClass.getName());
            }
            result.add(enumItem);
        }
        return result;
    }

    private Object translateSourceCollection(Class<? extends Enum<?>> enumClass, Collection srcCollection) {
        if (srcCollection.isEmpty()) {
            return EnumSetTranslator.createEmptyEnumSet(enumClass);
        }
        int typeMismatches = 0;
        Class<?> firstIncompatibleType = null;
        for (Object srcItem : srcCollection) {
            if (null == srcItem) {
                return null;
            }
            Class<?> srcItemClass = srcItem.getClass();
            if (enumClass.isAssignableFrom(srcItemClass)) continue;
            ++typeMismatches;
            if (null != firstIncompatibleType) continue;
            firstIncompatibleType = srcItemClass;
        }
        if (typeMismatches >= Math.min(2, srcCollection.size())) {
            return null;
        }
        if (null != firstIncompatibleType) {
            throw new ConfigurationDataException("invalid source for enum set of type " + enumClass.getName() + ", contains item of class " + firstIncompatibleType.getName());
        }
        try {
            return EnumSet.copyOf(srcCollection);
        }
        catch (Exception e) {
            throw new ConfigurationDataException("invalid source for enum set of type " + enumClass.getName(), e);
        }
    }

    private static Set<?> createEmptyEnumSet(Class<? extends Enum<?>> enumClass) {
        Class<? extends Enum<?>> elementClass = enumClass;
        EnumSet<? extends Enum<?>> result = EnumSet.noneOf(elementClass);
        return result;
    }

    private static Map<String, Enum<?>> createEnumIdMap(Class<? extends Enum<?>> enumClass) {
        Map<String, Object> result;
        Enum<?>[] constants = enumClass.getEnumConstants();
        assert (null != constants && constants.length > 0);
        HashMap mapById = new HashMap(constants.length);
        boolean hasCaseAmbiguousEntries = false;
        for (Enum<?> enumConst : constants) {
            String name = enumConst.name();
            Enum<?> prevConst = mapById.put(name.toLowerCase(), enumConst);
            if (null == prevConst) continue;
            hasCaseAmbiguousEntries = true;
            break;
        }
        if (hasCaseAmbiguousEntries) {
            mapById.clear();
            for (Enum<?> enumConst : constants) {
                String name = enumConst.name();
                mapById.put(name, enumConst);
            }
            result = mapById;
        } else {
            result = new SimpleKeyNormalizingMap(mapById);
        }
        return result;
    }
}

