/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.ConfigurationDataException;
import cz.auderis.tools.config.DataTranslator;
import cz.auderis.tools.config.DataTranslatorContext;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class InetAddressTranslator
implements DataTranslator {
    @Override
    public String getId() {
        return "inet address translator";
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int getTargetClassSupportPriority(Class<?> targetClass, DataTranslatorContext context) {
        if (targetClass.isAssignableFrom(InetAddress.class)) {
            return 10;
        }
        if (targetClass.isAssignableFrom(Inet4Address.class)) {
            return 11;
        }
        if (targetClass.isAssignableFrom(Inet6Address.class)) {
            return 11;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object translateToClass(Object source, Class<?> targetClass, DataTranslatorContext context) {
        block13: {
            if (null == source) {
                return null;
            }
            sourceClass = source.getClass();
            if (targetClass.isAssignableFrom(sourceClass)) {
                return source;
            }
            result = null;
            if (source instanceof byte[]) {
                addrBytes = (byte[])source;
                try {
                    result = InetAddress.getByAddress(addrBytes);
                }
                catch (UnknownHostException e) {
                    if (!context.isStrictModeEnabled()) ** GOTO lbl25
                    throw new ConfigurationDataException("cannot parse internet address '" + Arrays.toString(addrBytes) + "'", e);
                }
            } else if (source instanceof String) {
                addrText = (String)source;
                if (addrText.trim().isEmpty()) {
                    return InetAddressTranslator.NULL_OBJECT;
                }
                try {
                    result = InetAddress.getByName((String)source);
                }
                catch (Exception e) {
                    if (!context.isStrictModeEnabled()) break block13;
                    throw new ConfigurationDataException("cannot parse internet address '" + addrText + "'", e);
                }
            }
        }
        if (null == result) {
            return InetAddressTranslator.NULL_OBJECT;
        }
        if (targetClass.isAssignableFrom(result.getClass())) {
            return result;
        }
        if (context.isStrictModeEnabled()) {
            throw new ConfigurationDataException("invalid type of internet address " + result + ", expected type " + targetClass.getName());
        }
        return null;
    }
}

