/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.DataTranslator;
import cz.auderis.tools.config.DataTranslatorContext;

public abstract class SingleTargetClassTranslator
implements DataTranslator {
    protected final Class<?> supportedClass;

    protected SingleTargetClassTranslator(Class<?> supportedClass) {
        this.supportedClass = supportedClass;
    }

    protected abstract Object translate(Object var1, DataTranslatorContext var2);

    @Override
    public int getTargetClassSupportPriority(Class<?> targetClass, DataTranslatorContext context) {
        if (null == targetClass) {
            throw new NullPointerException();
        }
        if (targetClass.isAssignableFrom(this.supportedClass)) {
            return 10;
        }
        return 0;
    }

    @Override
    public Object translateToClass(Object source, Class<?> targetClass, DataTranslatorContext context) {
        if (null == targetClass) {
            throw new NullPointerException();
        }
        if (!targetClass.isAssignableFrom(this.supportedClass)) {
            throw new IllegalArgumentException("target class not supported by " + this.getId());
        }
        if (null == source || this.supportedClass.isAssignableFrom(source.getClass())) {
            return source;
        }
        Object result = this.translate(source, context);
        return result;
    }

    public String toString() {
        return this.getId();
    }
}

