/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.gradle;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.java.JavaLibrary;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;

public class TestSupportPlugin
implements Plugin<Project> {
    public static final String SUPPORT_SOURCE_SET_NAME = "testSupport";
    public static final String SUPPORT_CONFIGURATION_NAME = "testSupport";
    public static final String SUPPORT_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testSupportCompileClasspath";
    public static final String SUPPORT_RUNTIME_CONFIGURATION_NAME = "testSupportRuntime";
    public static final String SUPPORT_JAVADOC_TASK_NAME = "testSupportJavadoc";
    public static final String SUPPORT_JAR_TASK_NAME = "testSupportJar";
    public static final String SUPPORT_SOURCE_JAR_TASK_NAME = "testSupportSourceJar";
    public static final String SUPPORT_JAVADOC_JAR_TASK_NAME = "testSupportJavadocJar";
    public static final String SUPPORT_SOURCE_BASE = "src/test-support";
    public static final String SUPPORT_JAVA_SOURCES = "src/test-support/java";
    public static final String SUPPORT_RESOURCES = "src/test-support/resources";
    public static final String SUPPORT_JAR_APPENDIX = "test_support";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureSourceSet(javaConvention);
        this.configureConfigurations(javaConvention);
        this.configureJavadoc(javaConvention);
        this.configureArchives(javaConvention);
    }

    private void configureSourceSet(JavaPluginConvention convention) {
        SourceSetContainer sourceSets = convention.getSourceSets();
        SourceSet supportSet = (SourceSet)sourceSets.create("testSupport");
        this.defineSourceSetPaths(supportSet, (Project)convention.getProject());
        SourceSet mainSet = (SourceSet)sourceSets.getByName("main");
        ProjectInternal project = convention.getProject();
        supportSet.setCompileClasspath((FileCollection)project.files(new Object[]{mainSet.getOutput(), project.getConfigurations().getByName(SUPPORT_COMPILE_CLASSPATH_CONFIGURATION_NAME)}));
        supportSet.setRuntimeClasspath((FileCollection)project.files(new Object[]{supportSet.getOutput(), mainSet.getOutput(), project.getConfigurations().getByName(SUPPORT_RUNTIME_CONFIGURATION_NAME)}));
        SourceSet testSet = (SourceSet)sourceSets.getByName("test");
        testSet.setCompileClasspath(testSet.getCompileClasspath().plus((FileCollection)supportSet.getOutput()));
        testSet.setRuntimeClasspath(testSet.getRuntimeClasspath().plus((FileCollection)supportSet.getOutput()));
    }

    private void defineSourceSetPaths(SourceSet supportSet, final Project project) {
        supportSet.getJava().setSrcDirs(Collections.singleton(SUPPORT_JAVA_SOURCES));
        supportSet.getResources().setSrcDirs(Collections.singleton(SUPPORT_RESOURCES));
        ConventionMapping supportConventionMapping = ((IConventionAware)supportSet.getOutput()).getConventionMapping();
        supportConventionMapping.map("classesDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(project.getBuildDir(), "classes/test-support");
            }
        });
        supportConventionMapping.map("resourcesDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(project.getBuildDir(), "resources/test-support");
            }
        });
    }

    private void configureConfigurations(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration supportConfiguration = (Configuration)configurations.create("testSupport");
        supportConfiguration.setDescription("Configuration for test support artifacts");
        supportConfiguration.setVisible(true);
        SourceSet supportSet = (SourceSet)pluginConvention.getSourceSets().getByName("testSupport");
        Configuration supportRuntimeConfiguration = configurations.getByName(supportSet.getRuntimeConfigurationName());
        supportConfiguration.extendsFrom(new Configuration[]{supportRuntimeConfiguration});
        Configuration compileConfiguration = configurations.getByName("compile");
        Configuration runtimeConfiguration = configurations.getByName("runtime");
        Configuration supportCompileConfiguration = configurations.getByName(supportSet.getCompileConfigurationName());
        supportCompileConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        supportRuntimeConfiguration.extendsFrom(new Configuration[]{runtimeConfiguration});
    }

    private void configureJavadoc(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet supportSet = (SourceSet)pluginConvention.getSourceSets().getByName("testSupport");
        Javadoc supportJavadocTask = (Javadoc)project.getTasks().create(SUPPORT_JAVADOC_TASK_NAME, Javadoc.class);
        supportJavadocTask.setDescription("Generates Javadoc API documentation for the test support source code");
        supportJavadocTask.setGroup("documentation");
        supportJavadocTask.setClasspath(supportSet.getOutput().plus(supportSet.getCompileClasspath()));
        supportJavadocTask.source(new Object[]{supportSet.getAllJava()});
        supportJavadocTask.source(new Object[]{((SourceSet)pluginConvention.getSourceSets().getByName("main")).getAllJava()});
        supportJavadocTask.setDestinationDir(new File(pluginConvention.getDocsDir(), "test-support-javadoc"));
        Object version = project.getVersion();
        String fullProjectName = "unspecified".equals(version) ? project.getName() : project.getName() + ", version " + version;
        supportJavadocTask.setTitle("Test support API for " + fullProjectName);
    }

    private void configureArchives(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet supportSet = (SourceSet)pluginConvention.getSourceSets().getByName("testSupport");
        Jar supportJarTask = (Jar)project.getTasks().create(SUPPORT_JAR_TASK_NAME, Jar.class);
        supportJarTask.setDescription("Assembles a jar containing test support classes");
        supportJarTask.setGroup("build");
        supportJarTask.setAppendix(SUPPORT_JAR_APPENDIX);
        supportJarTask.from(new Object[]{supportSet.getOutput()});
        Jar supportSourceJarTask = (Jar)project.getTasks().create(SUPPORT_SOURCE_JAR_TASK_NAME, Jar.class);
        supportSourceJarTask.setDescription("Assembles a jar containing test support sources");
        supportSourceJarTask.setGroup("build");
        supportSourceJarTask.setAppendix(SUPPORT_JAR_APPENDIX);
        supportSourceJarTask.setClassifier("sources");
        supportSourceJarTask.from(new Object[]{supportSet.getAllJava()});
        Jar supportJavadocJarTask = (Jar)project.getTasks().create(SUPPORT_JAVADOC_JAR_TASK_NAME, Jar.class);
        supportJavadocJarTask.setDescription("Assembles a jar containing test support API documentation");
        supportJavadocJarTask.setGroup("documentation");
        supportJavadocJarTask.setAppendix(SUPPORT_JAR_APPENDIX);
        supportJavadocJarTask.setClassifier("javadoc");
        Task javadocTask = project.getTasks().getByName(SUPPORT_JAVADOC_TASK_NAME);
        supportJavadocJarTask.from(new Object[]{javadocTask});
        ArchivePublishArtifact supportArtifact = new ArchivePublishArtifact((AbstractArchiveTask)supportJarTask);
        ArchivePublishArtifact supportSourceArtifact = new ArchivePublishArtifact((AbstractArchiveTask)supportSourceJarTask);
        ArchivePublishArtifact supportJavadocArtifact = new ArchivePublishArtifact((AbstractArchiveTask)supportJavadocJarTask);
        Configuration supportConfiguration = project.getConfigurations().getByName("testSupport");
        supportConfiguration.getArtifacts().add((Object)supportArtifact);
        Configuration archivesConfiguration = project.getConfigurations().getByName("archives");
        archivesConfiguration.getArtifacts().add((Object)supportArtifact);
        archivesConfiguration.getArtifacts().add((Object)supportSourceArtifact);
        archivesConfiguration.getArtifacts().add((Object)supportJavadocArtifact);
        DefaultArtifactPublicationSet publicationSet = (DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class);
        publicationSet.addCandidate((PublishArtifact)supportArtifact);
        publicationSet.addCandidate((PublishArtifact)supportSourceArtifact);
        publicationSet.addCandidate((PublishArtifact)supportJavadocArtifact);
        JavaLibrary supportLibrary = new JavaLibrary((PublishArtifact)supportArtifact, supportConfiguration.getAllDependencies());
        project.getComponents().add((Object)supportLibrary);
        Task assembleTask = project.getTasks().getByName("assemble");
        assembleTask.dependsOn(new Object[]{supportConfiguration.getAllArtifacts().getBuildDependencies()});
    }
}

