/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.date;

import cz.auderis.test.parameter.convert.DateConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junitparams.converters.ConversionFailedException;

final class DateHelper {
    static final String DATE_ISO_FORMAT = "yyyy-MM-dd";
    static final String FULL_ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SS";
    static final List<Integer> TIME_UNIT_FIELDS;
    static final Map<Integer, String> DATE_FIELDS;
    static final Map<Integer, String> TIME_FIELDS;

    DateHelper() {
    }

    static String formatDate(int leastFieldUnit, Date d) {
        SimpleDateFormat format;
        assert (null != d);
        if (DATE_FIELDS.containsKey(leastFieldUnit)) {
            format = new SimpleDateFormat(DATE_ISO_FORMAT);
        } else {
            assert (TIME_FIELDS.containsKey(leastFieldUnit));
            format = new SimpleDateFormat(FULL_ISO_FORMAT);
        }
        return format.format(d);
    }

    static String[] formatDates(int leastFieldUnit, Object ... dates) {
        SimpleDateFormat format;
        assert (null != dates && dates.length > 0);
        if (DATE_FIELDS.containsKey(leastFieldUnit)) {
            format = new SimpleDateFormat(DATE_ISO_FORMAT);
        } else {
            assert (TIME_FIELDS.containsKey(leastFieldUnit));
            format = new SimpleDateFormat(FULL_ISO_FORMAT);
        }
        String[] result = new String[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            Date date;
            Object arg = dates[i];
            if (null == arg) {
                result[i] = null;
                continue;
            }
            if (arg instanceof Date) {
                date = (Date)arg;
            } else if (arg instanceof Calendar) {
                date = ((Calendar)arg).getTime();
            } else {
                throw new IllegalArgumentException("bad argument " + i);
            }
            result[i] = format.format(date);
        }
        return result;
    }

    static String getUnitName(int unitField) {
        if (DATE_FIELDS.containsKey(unitField)) {
            return DATE_FIELDS.get(unitField);
        }
        if (TIME_FIELDS.containsKey(unitField)) {
            return TIME_FIELDS.get(unitField);
        }
        throw new IllegalArgumentException("unsupported calendar field");
    }

    static Date parseDateAllowingNull(String dateText) {
        if (null == dateText || dateText.trim().isEmpty()) {
            return null;
        }
        return DateHelper.parseDate(dateText);
    }

    static Date parseDate(String dateText) {
        if (null == dateText) {
            throw new NullPointerException();
        }
        DateConverter parser = new DateConverter();
        try {
            return (Date)parser.convert(dateText, null);
        }
        catch (ConversionFailedException e) {
            try {
                DateFormat defaultDateTimeFormat = DateFormat.getDateTimeInstance();
                return defaultDateTimeFormat.parse(dateText);
            }
            catch (ParseException e2) {
                try {
                    DateFormat defaultFormat = DateFormat.getInstance();
                    return defaultFormat.parse(dateText);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException("Failed to parse date '" + dateText + "'");
                }
            }
        }
    }

    static List<Integer> majorFieldUnits(int leastMajorUnit) {
        int leastUnitIndex = TIME_UNIT_FIELDS.indexOf(leastMajorUnit);
        assert (leastUnitIndex >= 0);
        List<Integer> majorFields = TIME_UNIT_FIELDS.subList(0, leastUnitIndex + 1);
        return majorFields;
    }

    static List<Integer> minorFieldUnits(int leastMajorUnit) {
        int leastUnitIndex = TIME_UNIT_FIELDS.indexOf(leastMajorUnit);
        assert (leastUnitIndex >= 0);
        int allFieldCount = TIME_UNIT_FIELDS.size();
        if (leastUnitIndex == allFieldCount - 1) {
            return Collections.emptyList();
        }
        List<Integer> minorFields = TIME_UNIT_FIELDS.subList(leastUnitIndex + 1, allFieldCount);
        return minorFields;
    }

    static void setMinorFieldValues(Calendar targetCal, int ... fieldValues) {
        int allFieldCount = TIME_UNIT_FIELDS.size();
        assert (0 < fieldValues.length && fieldValues.length <= allFieldCount);
        ListIterator<Integer> fieldIterator = TIME_UNIT_FIELDS.listIterator(allFieldCount - fieldValues.length);
        for (int fieldValue : fieldValues) {
            assert (fieldIterator.hasNext());
            int minorField = (Integer)fieldIterator.next();
            targetCal.set(minorField, fieldValue);
        }
    }

    static void resetMinorFieldsToMinimum(Calendar targetCal, int leastMajorUnit) {
        for (Integer minorUnit : DateHelper.minorFieldUnits(leastMajorUnit)) {
            int minValue = targetCal.getActualMinimum(minorUnit);
            targetCal.set(minorUnit, minValue);
        }
    }

    static void resetMinorFieldsToMaximum(Calendar targetCal, int leastMajorUnit) {
        for (Integer minorUnit : DateHelper.minorFieldUnits(leastMajorUnit)) {
            int maxValue = targetCal.getActualMaximum(minorUnit);
            targetCal.set(minorUnit, maxValue);
        }
    }

    static {
        List<Integer> fieldList = Arrays.asList(1, 2, 5, 11, 12, 13, 14);
        TIME_UNIT_FIELDS = Collections.unmodifiableList(fieldList);
        LinkedHashMap<Integer, String> dateMap = new LinkedHashMap<Integer, String>(3);
        dateMap.put(1, "year");
        dateMap.put(2, "month");
        dateMap.put(5, "day");
        DATE_FIELDS = Collections.unmodifiableMap(dateMap);
        LinkedHashMap<Integer, String> timeMap = new LinkedHashMap<Integer, String>(4);
        timeMap.put(11, "hour");
        timeMap.put(12, "minute");
        timeMap.put(13, "second");
        timeMap.put(14, "millisecond");
        TIME_FIELDS = Collections.unmodifiableMap(timeMap);
    }
}

