/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.date;

import cz.auderis.test.matcher.date.DateHelper;
import cz.auderis.test.matcher.date.DateRangeMatcher;
import java.util.Date;
import org.hamcrest.Matcher;

public final class DateMatchers {
    public static <T> Matcher<Date> today() {
        Date now = new Date();
        return new DateRangeMatcher(now, now, 5, true, true);
    }

    public static <T> Matcher<Date> thisMonth() {
        Date now = new Date();
        return new DateRangeMatcher(now, now, 2, true, true);
    }

    public static <T> Matcher<Date> thisYear() {
        Date now = new Date();
        return new DateRangeMatcher(now, now, 1, true, true);
    }

    public static <T> Matcher<Date> sameDayAs(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(refDate, refDate, 5, true, true);
    }

    public static <T> Matcher<Date> sameMonthAs(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(refDate, refDate, 2, true, true);
    }

    public static <T> Matcher<Date> sameYearAs(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(refDate, refDate, 1, true, true);
    }

    public static <T> Matcher<Date> sameDayAs(String dateText) {
        Date refDate = DateHelper.parseDate(dateText);
        return new DateRangeMatcher(refDate, refDate, 5, true, true);
    }

    public static <T> Matcher<Date> sameMonthAs(String dateText) {
        Date refDate = DateHelper.parseDate(dateText);
        return new DateRangeMatcher(refDate, refDate, 2, true, true);
    }

    public static <T> Matcher<Date> sameYearAs(String dateText) {
        Date refDate = DateHelper.parseDate(dateText);
        return new DateRangeMatcher(refDate, refDate, 1, true, true);
    }

    public static <T> Matcher<Date> beforeDate(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(null, refDate, 5, true, false);
    }

    public static <T> Matcher<Date> beforeDate(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return new DateRangeMatcher(null, refDate, 5, true, false);
    }

    public static <T> Matcher<Date> before(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(null, refDate, 14, true, false);
    }

    public static <T> Matcher<Date> before(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return new DateRangeMatcher(null, refDate, 14, true, false);
    }

    public static <T> Matcher<Date> afterDate(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(refDate, null, 5, false, true);
    }

    public static <T> Matcher<Date> afterDate(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return new DateRangeMatcher(refDate, null, 5, false, true);
    }

    public static <T> Matcher<Date> after(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return new DateRangeMatcher(refDate, null, 14, false, true);
    }

    public static <T> Matcher<Date> after(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return new DateRangeMatcher(refDate, null, 14, false, true);
    }

    public static <T> Matcher<Date> betweenDates(Date startDate, Date endDate) {
        return new DateRangeMatcher(startDate, endDate, 5, true, true);
    }

    public static <T> Matcher<Date> betweenDates(String startDateText, String endDateText) {
        Date startDate = DateHelper.parseDateAllowingNull(startDateText);
        Date endDate = DateHelper.parseDateAllowingNull(endDateText);
        return new DateRangeMatcher(startDate, endDate, 5, true, true);
    }

    public static <T> Matcher<Date> between(Date startDate, Date endDate) {
        return new DateRangeMatcher(startDate, endDate, 14, true, true);
    }

    public static <T> Matcher<Date> between(String startDateText, String endDateText) {
        Date startDate = DateHelper.parseDateAllowingNull(startDateText);
        Date endDate = DateHelper.parseDateAllowingNull(endDateText);
        return new DateRangeMatcher(startDate, endDate, 14, true, true);
    }

    private DateMatchers() {
        throw new AssertionError();
    }
}

