/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.date;

import cz.auderis.test.matcher.date.DateHelper;
import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class DateRangeMatcher
extends TypeSafeMatcher<Date> {
    private final Calendar rangeStart;
    private final Calendar rangeEnd;
    private final int leastTimeUnit;

    DateRangeMatcher(Date start, Date end, int leastTimeUnit, boolean includeStart, boolean includeEnd) {
        super(Date.class);
        if (null == start && null == end) {
            throw new IllegalArgumentException("at most one range endpoint may be null");
        }
        if (null != start && null != end && end.before(start)) {
            throw new IllegalArgumentException("end date precedes start date");
        }
        if (!DateHelper.TIME_UNIT_FIELDS.contains(leastTimeUnit)) {
            throw new IllegalArgumentException("unrecognized time unit");
        }
        this.leastTimeUnit = leastTimeUnit;
        if (null != start) {
            this.rangeStart = Calendar.getInstance();
            this.rangeStart.setTime(start);
            if (!includeStart) {
                this.rangeStart.add(leastTimeUnit, 1);
            }
            DateHelper.resetMinorFieldsToMinimum(this.rangeStart, leastTimeUnit);
        } else {
            this.rangeStart = null;
        }
        if (null != end) {
            this.rangeEnd = Calendar.getInstance();
            this.rangeEnd.setTime(end);
            if (!includeEnd) {
                this.rangeEnd.add(leastTimeUnit, -1);
            }
            DateHelper.resetMinorFieldsToMaximum(this.rangeEnd, leastTimeUnit);
        } else {
            this.rangeEnd = null;
        }
    }

    protected boolean matchesSafely(Date testedDate) {
        Calendar testCalendar = Calendar.getInstance();
        testCalendar.setTime(testedDate);
        if (null != this.rangeStart && testCalendar.before(this.rangeStart)) {
            return false;
        }
        return null == this.rangeEnd || !testCalendar.after(this.rangeEnd);
    }

    public void describeTo(Description description) {
        String[] isoDates = DateHelper.formatDates(this.leastTimeUnit, this.rangeStart, this.rangeEnd);
        if (null == this.rangeEnd) {
            description.appendText("same or later date as ").appendText(isoDates[0]);
        } else if (null == this.rangeStart) {
            description.appendText("same or earlier date as ").appendText(isoDates[1]);
        } else {
            description.appendText("date between ").appendText(isoDates[0]);
            description.appendText(" and ").appendText(isoDates[1]);
        }
    }

    protected void describeMismatchSafely(Date testedDate, Description desc) {
        String[] isoDates = DateHelper.formatDates(this.leastTimeUnit, testedDate, this.rangeStart, this.rangeEnd);
        desc.appendValue((Object)isoDates[0]);
        Calendar testCalendar = Calendar.getInstance();
        testCalendar.setTime(testedDate);
        if (null != this.rangeStart && testCalendar.before(this.rangeStart)) {
            desc.appendText(" is before start date ").appendText(isoDates[1]);
        } else {
            assert (null != this.rangeEnd && testCalendar.after(this.rangeEnd));
            desc.appendText(" is after end date ").appendText(isoDates[2]);
        }
    }
}

