/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.convert;

import cz.auderis.test.parameter.convert.AbstractTypeConverter;
import java.math.BigInteger;
import junitparams.converters.ConversionFailedException;

public class BigIntegerConverter
extends AbstractTypeConverter<BigInteger> {
    public BigIntegerConverter() {
        super(BigInteger.class);
    }

    @Override
    protected BigInteger fromString(String objText, String option) throws ConversionFailedException {
        try {
            return new BigInteger(objText);
        }
        catch (NumberFormatException e) {
            throw new ConversionFailedException(e.getMessage());
        }
    }

    @Override
    protected BigInteger fromOtherType(Object obj, String option) throws ConversionFailedException {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return BigInteger.valueOf(((Number)obj).longValue());
        }
        return (BigInteger)super.fromOtherType(obj, option);
    }
}

