/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.convert;

import cz.auderis.test.parameter.convert.AbstractTypeConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junitparams.converters.ConversionFailedException;

public class DateConverter
extends AbstractTypeConverter<Date> {
    static final Pattern FULL_ISO_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}([T ])\\d{2}:\\d{2}:\\d{2}((?:\\.\\d{3})?)");
    static final Pattern COMPACT_ISO_PATTERN = Pattern.compile("\\d{4}(-?)\\d{2}\\1\\d{2}([T ]?)\\d{2}(:?)\\d{2}\\3\\d{2}");
    static final Pattern DATE_ISO_PATTERN = Pattern.compile("\\d{4}(-?)\\d{2}\\1\\d{2}");

    public DateConverter() {
        super(Date.class);
    }

    @Override
    protected Date fromString(String objText, String option) throws ConversionFailedException {
        if (objText.trim().isEmpty()) {
            return null;
        }
        DateFormat format = DateConverter.determineDatePattern(objText, option);
        try {
            return format.parse(objText);
        }
        catch (ParseException e) {
            throw new ConversionFailedException("Cannot parse date '" + objText + "': " + e.getMessage());
        }
    }

    static DateFormat determineDatePattern(String textParam, String options) throws ConversionFailedException {
        DateFormat format;
        if (null != options && !options.trim().isEmpty()) {
            try {
                format = new SimpleDateFormat(options);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionFailedException(e.getMessage());
            }
        } else {
            format = DateConverter.recognizeStandardDatePattern(textParam);
        }
        return format;
    }

    private static DateFormat recognizeStandardDatePattern(String textParam) throws ConversionFailedException {
        StringBuilder formatBuilder = new StringBuilder(32);
        Matcher matcher = FULL_ISO_PATTERN.matcher(textParam);
        if (matcher.matches()) {
            formatBuilder.append("yyyy-MM-dd");
            String dateTimeSeparator = matcher.group(1);
            formatBuilder.append('\'').append(dateTimeSeparator).append('\'');
            formatBuilder.append("HH:mm:ss");
            String millisPart = matcher.group(2);
            if (null != millisPart && !millisPart.isEmpty()) {
                formatBuilder.append(".SSS");
            }
            return new SimpleDateFormat(formatBuilder.toString());
        }
        matcher.usePattern(COMPACT_ISO_PATTERN).reset();
        if (matcher.matches()) {
            String datePartSeparator = matcher.group(1);
            formatBuilder.append("yyyy");
            formatBuilder.append(datePartSeparator).append("MM");
            formatBuilder.append(datePartSeparator).append("dd");
            String dateTimeSeparator = matcher.group(2);
            if (!dateTimeSeparator.isEmpty()) {
                formatBuilder.append('\'').append(dateTimeSeparator).append('\'');
            }
            String timePartSeparator = matcher.group(3);
            formatBuilder.append("HH");
            formatBuilder.append(timePartSeparator).append("mm");
            formatBuilder.append(timePartSeparator).append("ss");
            return new SimpleDateFormat(formatBuilder.toString());
        }
        matcher.usePattern(DATE_ISO_PATTERN).reset();
        if (matcher.matches()) {
            String datePartSeparator = matcher.group(1);
            formatBuilder.append("yyyy");
            formatBuilder.append(datePartSeparator).append("MM");
            formatBuilder.append(datePartSeparator).append("dd");
            return new SimpleDateFormat(formatBuilder.toString());
        }
        throw new ConversionFailedException("Cannot determine date format of '" + textParam + "'");
    }
}

