/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import java.math.BigDecimal;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class BigDecEqualityMatcher
extends TypeSafeMatcher<BigDecimal> {
    private final BigDecimal expectedValue;
    private final boolean strictMatch;

    protected BigDecEqualityMatcher(BigDecimal expectedValue, boolean strictMatch) {
        super(BigDecimal.class);
        assert (null != expectedValue);
        this.expectedValue = expectedValue;
        this.strictMatch = strictMatch;
    }

    protected boolean matchesSafely(BigDecimal num) {
        boolean match = this.strictMatch ? this.expectedValue.equals(num) : 0 == this.expectedValue.compareTo(num);
        return match;
    }

    public void describeTo(Description description) {
        description.appendText("decimal value ");
        description.appendValue((Object)this.expectedValue);
        if (this.strictMatch) {
            description.appendText(" with scale " + this.expectedValue.scale());
        }
    }

    protected void describeMismatchSafely(BigDecimal num, Description out) {
        boolean sameValue;
        out.appendText("value ").appendValue((Object)num);
        boolean bl = sameValue = 0 == this.expectedValue.compareTo(num);
        if (!sameValue) {
            BigDecimal delta = num.subtract(this.expectedValue);
            out.appendText(" was different by " + delta.toPlainString());
        } else if (this.strictMatch) {
            out.appendText(" had scale " + num.scale());
        }
    }
}

