/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.rule;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WorkFolder
extends TemporaryFolder {
    private Class<?> resourceSearchBaseClass;
    private Class<?> currentTestClass;

    public static WorkFolder basic() {
        return new WorkFolder();
    }

    public static WorkFolder subfolderOf(File parentFolder) {
        return new WorkFolder(parentFolder);
    }

    public static WorkFolder subfolderOf(String parentFolderPath) {
        File parentFolder = null == parentFolderPath || parentFolderPath.isEmpty() ? null : new File(parentFolderPath);
        return new WorkFolder(parentFolder);
    }

    protected WorkFolder() {
    }

    protected WorkFolder(File parentFolder) {
        super(parentFolder);
    }

    public WorkFolder withResourceSearchBase(Class<?> searchBase) {
        this.resourceSearchBaseClass = searchBase;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        final Class testClass = description.getTestClass();
        final Statement statement = super.apply(base, description);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    WorkFolder.this.currentTestClass = testClass;
                    statement.evaluate();
                }
                finally {
                    WorkFolder.this.currentTestClass = null;
                }
            }
        };
    }

    public File newFile(String targetPath, InputStream initialContents) throws IOException {
        if (null == targetPath) {
            throw new NullPointerException();
        }
        File target = this.prepareTargetFile(targetPath);
        if (null != initialContents) {
            this.copyContents(target, initialContents);
        } else {
            target.createNewFile();
        }
        return target;
    }

    public File newResourceCopy(String targetPath, String resourceName) throws IOException {
        if (null == targetPath || null == resourceName) {
            throw new NullPointerException();
        }
        InputStream resourceStream = this.openResource(resourceName);
        return this.newFile(targetPath, resourceStream);
    }

    public File newResourceCopy(String resourceName) throws IOException {
        int filenameStart = -1 != resourceName.indexOf(47) ? 1 + resourceName.lastIndexOf(47) : ('/' != File.separatorChar && -1 != resourceName.indexOf(File.separatorChar) ? 1 + resourceName.lastIndexOf(File.separatorChar) : 0);
        if (filenameStart >= resourceName.length()) {
            throw new IllegalArgumentException("Cannot find filename part in resource name: " + resourceName);
        }
        String fileName = resourceName.substring(filenameStart);
        return this.newResourceCopy(fileName, resourceName);
    }

    private File prepareTargetFile(String targetPath) {
        File target = new File(this.getRoot(), targetPath);
        File fileFolder = target.getParentFile();
        if (null != fileFolder && !fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyContents(File target, InputStream initialContents) throws IOException {
        FileOutputStream targetStream = new FileOutputStream(target, false);
        try {
            int readBytes;
            byte[] buffer = new byte[8192];
            while (-1 != (readBytes = initialContents.read(buffer))) {
                targetStream.write(buffer, 0, readBytes);
            }
        }
        finally {
            this.silentClose(targetStream);
            this.silentClose(initialContents);
        }
    }

    private void silentClose(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private InputStream openResource(String resourceName) throws IOException {
        Class<?> searchBase = null != this.resourceSearchBaseClass ? this.resourceSearchBaseClass : this.currentTestClass;
        return searchBase.getResourceAsStream(resourceName);
    }
}

