/*
 * Copyright 2016 Boleslav Bobcik - Auderis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cz.auderis.test.matcher.array;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class PrimitiveArrayMatcher extends BaseMatcher<Object> {

    public PrimitiveArrayMatcher(Class<?> itemType, Object expectedSubArray) {
        if ((null == itemType) || (null == expectedSubArray)) {
            throw new NullPointerException();
        } else if (!expectedSubArray.getClass().isArray()) {
            throw new IllegalArgumentException("expected sequence argument must be an array");
        } else if (itemType != expectedSubArray.getClass().getComponentType()) {
//            throw new
        }


        this.primitiveBaseType = itemType;
        this.expectedSubArray = expectedSubArray;
    }

    private Class<?> primitiveBaseType;
    private Object   expectedSubArray;




    @Override
    public boolean matches(Object item) {
        return false;
    }

    @Override
    public void describeTo(Description description) {

    }
}
