/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.rawarray;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IsByteArrayContainingMatcher
extends TypeSafeMatcher<byte[]> {
    private final byte[] expectedData;

    public IsByteArrayContainingMatcher(byte[] expectedData) {
        super(byte[].class);
        this.expectedData = expectedData;
    }

    public IsByteArrayContainingMatcher(int ... intValues) {
        super(byte[].class);
        this.expectedData = new byte[intValues.length];
        for (int i = 0; i < intValues.length; ++i) {
            this.expectedData[i] = (byte)intValues[i];
        }
    }

    protected boolean matchesSafely(byte[] bytes) {
        return Arrays.equals(bytes, this.expectedData);
    }

    public void describeTo(Description description) {
        description.appendText("byte array of size " + this.expectedData.length);
        if (0 == this.expectedData.length) {
            return;
        }
        description.appendText(" containing ");
        description.appendText(IsByteArrayContainingMatcher.formatByteArray(this.expectedData).toString());
    }

    protected void describeMismatchSafely(byte[] bytes, Description out) {
        int size = bytes.length;
        if (size != this.expectedData.length) {
            out.appendText("data size was " + size);
        } else {
            out.appendText("was ").appendText(IsByteArrayContainingMatcher.formatByteArray(bytes).toString());
        }
    }

    static StringBuilder formatByteArray(byte[] data) {
        StringBuilder str = new StringBuilder(3 * data.length + 1);
        str.append('<');
        char separator = '\u0000';
        for (byte x : data) {
            if ('\u0000' == separator) {
                separator = ':';
            } else {
                str.append(separator);
            }
            int byteValue = 0xFF & x;
            str.append(Character.forDigit(byteValue >>> 4, 16));
            str.append(Character.forDigit(byteValue & 0xF, 16));
        }
        str.append('>');
        return str;
    }
}

