/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public enum LogLevel {
    FATAL,
    ERROR,
    WARNING,
    INFO,
    DEBUG,
    TRACE;


    public EnumSet<LogLevel> getHigherLevels() {
        if (FATAL == this) {
            return EnumSet.noneOf(LogLevel.class);
        }
        return EnumSet.range(FATAL, LogLevel.values()[this.ordinal() - 1]);
    }

    public EnumSet<LogLevel> getLowerLevels() {
        if (TRACE == this) {
            return EnumSet.noneOf(LogLevel.class);
        }
        return EnumSet.range(LogLevel.values()[this.ordinal() + 1], TRACE);
    }

    public EnumSet<LogLevel> plusHigherLevels() {
        return EnumSet.range(FATAL, this);
    }

    public EnumSet<LogLevel> plusLowerLevels() {
        return EnumSet.range(this, TRACE);
    }

    public static LogLevel lowestLevel(Collection<LogLevel> levels) {
        if (levels.isEmpty()) {
            return FATAL;
        }
        return Collections.min(levels);
    }
}

