/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.log4j;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogRecord;
import cz.auderis.test.logging.LogRecordCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Log4jLoggerAdapter
extends Logger {
    public static final Map<Level, LogLevel> LOG4J_TO_INTERNAL = Log4jLoggerAdapter.prepareLevelMap();

    private static Map<Level, LogLevel> prepareLevelMap() {
        HashMap<Level, LogLevel> levelMap = new HashMap<Level, LogLevel>();
        levelMap.put(Level.TRACE, LogLevel.TRACE);
        levelMap.put(Level.DEBUG, LogLevel.DEBUG);
        levelMap.put(Level.INFO, LogLevel.INFO);
        levelMap.put(Level.WARN, LogLevel.WARNING);
        levelMap.put(Level.ERROR, LogLevel.ERROR);
        levelMap.put(Level.FATAL, LogLevel.FATAL);
        return Collections.unmodifiableMap(levelMap);
    }

    protected Log4jLoggerAdapter(String name) {
        super(name);
    }

    public void fatal(Object message) {
        this.forcedLog(null, (Priority)Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.forcedLog(null, (Priority)Level.FATAL, message, t);
    }

    public void error(Object message) {
        this.forcedLog(null, (Priority)Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.forcedLog(null, (Priority)Level.ERROR, message, t);
    }

    public void warn(Object message) {
        this.forcedLog(null, (Priority)Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.forcedLog(null, (Priority)Level.WARN, message, t);
    }

    public void info(Object message) {
        this.forcedLog(null, (Priority)Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.forcedLog(null, (Priority)Level.INFO, message, t);
    }

    public void debug(Object message) {
        this.forcedLog(null, (Priority)Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.forcedLog(null, (Priority)Level.DEBUG, message, t);
    }

    public void trace(Object message) {
        this.forcedLog(null, (Priority)Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.forcedLog(null, (Priority)Level.TRACE, message, t);
    }

    protected void forcedLog(String ignored, Priority level, Object message, Throwable t) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel internalLevel = LOG4J_TO_INTERNAL.get((Level)level);
        if (null == internalLevel || !recordCollector.isLevelEnabled(internalLevel)) {
            return;
        }
        String msgText = null == message ? "" : (message instanceof String ? (String)message : message.toString());
        LogRecord record = new LogRecord(internalLevel, this.name, msgText, t);
        recordCollector.add(record);
    }

    public boolean isTraceEnabled() {
        return LogRecordCollector.RECORD_COLLECTOR.isLevelEnabled(LogLevel.TRACE);
    }

    public boolean isDebugEnabled() {
        return LogRecordCollector.RECORD_COLLECTOR.isLevelEnabled(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return LogRecordCollector.RECORD_COLLECTOR.isLevelEnabled(LogLevel.INFO);
    }
}

