/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.jboss;

import cz.auderis.test.logging.jboss.JBossLoggerAdapter;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;

public class JBossLoggerProvider
implements LoggerProvider {
    static final JBossLoggerProvider INSTANCE = new JBossLoggerProvider();
    private static final ConcurrentMap<String, JBossLoggerAdapter> LOGGERS = new ConcurrentHashMap<String, JBossLoggerAdapter>(16);
    final Map<String, Object> mdc = new HashMap<String, Object>(4);
    final Deque<String> ndc = new LinkedList<String>();

    private JBossLoggerProvider() {
    }

    public Logger getLogger(String name) {
        JBossLoggerAdapter logger = (JBossLoggerAdapter)((Object)LOGGERS.get(name));
        if (null == logger) {
            JBossLoggerAdapter newLogger = new JBossLoggerAdapter(name);
            JBossLoggerAdapter origLogger = LOGGERS.putIfAbsent(name, newLogger);
            logger = null != origLogger ? origLogger : newLogger;
        }
        return logger;
    }

    public void clearMdc() {
        this.mdc.clear();
    }

    public Object putMdc(String key, Object value) {
        return this.mdc.put(key, value);
    }

    public Object getMdc(String key) {
        return this.mdc.get(key);
    }

    public void removeMdc(String key) {
        this.mdc.remove(key);
    }

    public Map<String, Object> getMdcMap() {
        return new HashMap<String, Object>(this.mdc);
    }

    public void clearNdc() {
        this.ndc.clear();
    }

    public String getNdc() {
        return this.ndc.peek();
    }

    public int getNdcDepth() {
        return this.ndc.size();
    }

    public String popNdc() {
        return this.ndc.poll();
    }

    public String peekNdc() {
        String topValue = this.ndc.peek();
        return null != topValue ? topValue : "";
    }

    public void pushNdc(String message) {
        this.ndc.addFirst(message);
    }

    public void setNdcMaxDepth(int maxDepth) {
    }
}

