/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.slf4j;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogRecord;
import cz.auderis.test.logging.LogRecordCollector;
import java.util.Arrays;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class Slf4jLoggerAdapter
extends MarkerIgnoringBase {
    public Slf4jLoggerAdapter(String name) {
        this.name = name;
    }

    private boolean isLevelEnabled(LogLevel level) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        return recordCollector.isLevelEnabled(level);
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(LogLevel.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(LogLevel.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(LogLevel.ERROR);
    }

    private void log(LogLevel currentLevel, String s, Object o) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            assert (!(o instanceof Throwable));
            String msg = this.render(s, o);
            recordCollector.add(new LogRecord(currentLevel, this.name, msg, null));
        }
    }

    private void log(LogLevel currentLevel, String s, Object o1, Object o2) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            String msg;
            Throwable cause;
            if (o2 instanceof Throwable) {
                cause = (Throwable)o2;
                msg = this.render(s, o1);
            } else {
                cause = null;
                msg = this.render(s, o1, o2);
            }
            recordCollector.add(new LogRecord(currentLevel, this.name, msg, cause));
        }
    }

    private void log(LogLevel currentLevel, String s, Object[] objects) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            String msg;
            Throwable cause;
            if (0 != objects.length && objects[objects.length - 1] instanceof Throwable) {
                cause = (Throwable)objects[objects.length - 1];
                msg = this.render(s, true, objects);
            } else {
                cause = null;
                msg = this.render(s, false, objects);
            }
            recordCollector.add(new LogRecord(currentLevel, this.name, msg, cause));
        }
    }

    public void trace(String s) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.TRACE;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, null));
        }
    }

    public void trace(String s, Throwable throwable) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.TRACE;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, throwable));
        }
    }

    public void trace(String s, Object o) {
        this.log(LogLevel.TRACE, s, o);
    }

    public void trace(String s, Object o1, Object o2) {
        this.log(LogLevel.TRACE, s, o1, o2);
    }

    public void trace(String s, Object ... objects) {
        this.log(LogLevel.TRACE, s, objects);
    }

    public void debug(String s) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.DEBUG;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, null));
        }
    }

    public void debug(String s, Throwable throwable) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.DEBUG;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, throwable));
        }
    }

    public void debug(String s, Object o) {
        this.log(LogLevel.DEBUG, s, o);
    }

    public void debug(String s, Object o1, Object o2) {
        this.log(LogLevel.DEBUG, s, o1, o2);
    }

    public void debug(String s, Object ... objects) {
        this.log(LogLevel.DEBUG, s, objects);
    }

    public void info(String s) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.INFO;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, null));
        }
    }

    public void info(String s, Throwable throwable) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.INFO;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, throwable));
        }
    }

    public void info(String s, Object o) {
        this.log(LogLevel.INFO, s, o);
    }

    public void info(String s, Object o1, Object o2) {
        this.log(LogLevel.INFO, s, o1, o2);
    }

    public void info(String s, Object ... objects) {
        this.log(LogLevel.INFO, s, objects);
    }

    public void warn(String s) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.WARNING;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, null));
        }
    }

    public void warn(String s, Throwable throwable) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.WARNING;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, throwable));
        }
    }

    public void warn(String s, Object o) {
        this.log(LogLevel.WARNING, s, o);
    }

    public void warn(String s, Object o1, Object o2) {
        this.log(LogLevel.WARNING, s, o1, o2);
    }

    public void warn(String s, Object ... objects) {
        this.log(LogLevel.WARNING, s, objects);
    }

    public void error(String s) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.ERROR;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, null));
        }
    }

    public void error(String s, Throwable throwable) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel currentLevel = LogLevel.ERROR;
        if (recordCollector.isLevelEnabled(currentLevel)) {
            recordCollector.add(new LogRecord(currentLevel, this.name, s, throwable));
        }
    }

    public void error(String s, Object o) {
        this.log(LogLevel.ERROR, s, o);
    }

    public void error(String s, Object o1, Object o2) {
        this.log(LogLevel.ERROR, s, o1, o2);
    }

    public void error(String s, Object ... objects) {
        this.log(LogLevel.ERROR, s, objects);
    }

    private String render(String msg, Object o) {
        assert (!(o instanceof Throwable));
        FormattingTuple fmtTuple = MessageFormatter.arrayFormat((String)msg, (Object[])new Object[]{o}, null);
        return fmtTuple.getMessage();
    }

    private String render(String msg, Object o1, Object o2) {
        assert (!(o2 instanceof Throwable));
        FormattingTuple fmtTuple = MessageFormatter.arrayFormat((String)msg, (Object[])new Object[]{o1, o2}, null);
        return fmtTuple.getMessage();
    }

    private String render(String msg, boolean ignoreLast, Object[] objects) {
        Object[] objectArg;
        assert (objects.length > 0);
        assert (ignoreLast || !(objects[objects.length - 1] instanceof Throwable));
        if (!ignoreLast || null == msg) {
            objectArg = objects;
        } else {
            int availableParameters = objects.length - 1;
            int placeholderCount = 0;
            int searchIndex = 0;
            while (placeholderCount <= availableParameters && -1 != (searchIndex = msg.indexOf(123, searchIndex))) {
                ++placeholderCount;
                ++searchIndex;
            }
            objectArg = placeholderCount <= availableParameters ? objects : Arrays.copyOf(objects, availableParameters);
        }
        FormattingTuple fmtTuple = MessageFormatter.arrayFormat((String)msg, (Object[])objectArg, null);
        return fmtTuple.getMessage();
    }
}

