/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.text;

import cz.auderis.test.matcher.text.SimpleCharPatternMatcher;

enum CommonCharPattern implements SimpleCharPatternMatcher.CharSequencePattern
{
    JAVA_IDENTIFIER{

        @Override
        public boolean isValidStartChar(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        @Override
        public boolean isValidChar(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public String toString() {
            return "Java identifier";
        }
    }
    ,
    XML_NAME{

        @Override
        public boolean isValidStartChar(char c) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                return true;
            }
            if (':' == c || '_' == c) {
                return true;
            }
            if (c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff') {
                return true;
            }
            if (c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d') {
                return true;
            }
            if (c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff') {
                return true;
            }
            return c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd';
        }

        @Override
        public boolean isValidChar(char c) {
            if ('-' == c || '.' == c || '\u00b7' == c) {
                return true;
            }
            if (c >= '0' && c <= '9' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040') {
                return true;
            }
            return this.isValidStartChar(c);
        }

        public String toString() {
            return "XML name";
        }
    }
    ,
    DECIMAL_DIGITS{

        @Override
        public boolean isValidStartChar(char c) {
            if ('-' == c || '+' == c) {
                return true;
            }
            return this.isValidChar(c);
        }

        @Override
        public boolean isValidChar(char c) {
            return c >= '0' && c <= '9';
        }

        public String toString() {
            return "sequence of decimal digits";
        }
    }
    ,
    HEXADECIMAL_DIGITS{

        @Override
        public boolean isValidStartChar(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        @Override
        public boolean isValidChar(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        public String toString() {
            return "sequence of hexadecimal digits";
        }
    }
    ,
    BINARY_DIGITS{

        @Override
        public boolean isValidStartChar(char c) {
            return '0' == c || '1' == c;
        }

        @Override
        public boolean isValidChar(char c) {
            return '0' == c || '1' == c;
        }

        public String toString() {
            return "sequence of binary digits";
        }
    };

}

