/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import cz.auderis.test.parameter.annotation.UsingFactory;
import cz.auderis.test.parameter.annotation.impl.PropertyEditorAnnotationConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import junitparams.converters.ConversionFailedException;
import junitparams.converters.Converter;

public class UsingFactoryAnnotationConverter
implements Converter<UsingFactory, Object> {
    Class<?> targetType;
    Method factoryMethod;

    public void initialize(UsingFactory annotation) {
        Class<?> factoryClass = annotation.type();
        String methodName = annotation.method();
        Class<?> targetClass = PropertyEditorAnnotationConverter.optionalClass(annotation.targetType());
        HashSet<Method> candidateMethods = new HashSet<Method>(4);
        for (Method method : factoryClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!Modifier.isStatic(method.getModifiers()) || !methodName.equals(method.getName()) || 1 != (parameterTypes = method.getParameterTypes()).length || !parameterTypes[0].isAssignableFrom(String.class) || null != targetClass && !targetClass.isAssignableFrom(method.getReturnType())) continue;
            candidateMethods.add(method);
        }
        if (candidateMethods.isEmpty()) {
            throw new IllegalArgumentException("Cannot find factory method '" + methodName + "' in class " + factoryClass);
        }
        if (candidateMethods.size() > 1) {
            throw new IllegalArgumentException("Ambiguous factory methods '" + methodName + "' in class " + factoryClass);
        }
        this.factoryMethod = (Method)candidateMethods.iterator().next();
        this.targetType = targetClass;
    }

    public Object convert(Object param) throws ConversionFailedException {
        Object result;
        try {
            String paramString = PropertyEditorAnnotationConverter.asString(param);
            result = this.factoryMethod.invoke(null, paramString);
        }
        catch (Exception e) {
            throw new ConversionFailedException("Cannot convert value '" + param + "' using factory method " + this.factoryMethod);
        }
        if (null != this.targetType) {
            if (null == result && this.targetType.isPrimitive()) {
                throw new ConversionFailedException("Bad conversion result of value '" + param + "' using factory method " + this.factoryMethod + ": cannot use null for primitive target type " + this.targetType);
            }
            if (null != result && !this.targetType.isAssignableFrom(result.getClass())) {
                throw new ConversionFailedException("Bad conversion result of value '" + param + "' using factory method " + this.factoryMethod + ": cannot assign " + result.getClass() + " into " + this.targetType);
            }
        }
        return result;
    }
}

