/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support;

import java.util.Deque;
import java.util.LinkedList;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;

public class NaturalDescriptionJoiner
implements SelfDescribing {
    Object prefix;
    Object suffix;
    Object normalSeparator;
    Object lastSeparator;
    boolean usePrefixWhenEmpty;
    boolean useSuffixWhenEmpty;
    final Deque<DescriptionItem> items;

    public NaturalDescriptionJoiner(Object prefix, Object normalSeparator, Object lastSeparator, Object suffix) {
        this.prefix = prefix;
        this.normalSeparator = null != normalSeparator ? normalSeparator : "";
        this.lastSeparator = null != lastSeparator ? lastSeparator : "";
        this.suffix = suffix;
        this.items = new LinkedList<DescriptionItem>();
    }

    public NaturalDescriptionJoiner() {
        this(null, ", ", " and ", null);
    }

    public NaturalDescriptionJoiner(Object separator) {
        this(null, separator, separator, null);
    }

    public NaturalDescriptionJoiner(Object normalSeparator, Object lastSeparator) {
        this(null, normalSeparator, lastSeparator, null);
    }

    public NaturalDescriptionJoiner withPrefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public NaturalDescriptionJoiner withSuffix(Object suffix) {
        this.suffix = suffix;
        return this;
    }

    public NaturalDescriptionJoiner withNormalSeparator(Object normalSep) {
        this.normalSeparator = null != normalSep ? normalSep : "";
        return this;
    }

    public NaturalDescriptionJoiner withLastSeparator(Object lastSep) {
        this.lastSeparator = null != lastSep ? lastSep : "";
        return this;
    }

    public boolean isUsePrefixWhenEmpty() {
        return this.usePrefixWhenEmpty;
    }

    public void setUsePrefixWhenEmpty(boolean usePrefixWhenEmpty) {
        this.usePrefixWhenEmpty = usePrefixWhenEmpty;
    }

    public NaturalDescriptionJoiner withPrefixWhenEmpty() {
        this.usePrefixWhenEmpty = true;
        return this;
    }

    public NaturalDescriptionJoiner withoutPrefixWhenEmpty() {
        this.usePrefixWhenEmpty = false;
        return this;
    }

    public boolean isUseSuffixWhenEmpty() {
        return this.useSuffixWhenEmpty;
    }

    public void setUseSuffixWhenEmpty(boolean useSuffixWhenEmpty) {
        this.useSuffixWhenEmpty = useSuffixWhenEmpty;
    }

    public NaturalDescriptionJoiner withSuffixWhenEmpty() {
        this.useSuffixWhenEmpty = true;
        return this;
    }

    public NaturalDescriptionJoiner withoutSuffixWhenEmpty() {
        this.useSuffixWhenEmpty = false;
        return this;
    }

    public NaturalDescriptionJoiner add(Object valuePrefix, Object value, Object valueSuffix) {
        if (null != value) {
            DescriptionItem item = new DescriptionItem(valuePrefix, value, valueSuffix);
            this.items.add(item);
        }
        return this;
    }

    public void add(Object valuePrefix, Object value) {
        this.add(valuePrefix, value, null);
    }

    public void add(Object value) {
        this.add(null, value, null);
    }

    public void describeTo(Description desc) {
        int itemCount = this.items.size();
        if (null == desc || 0 == itemCount && !this.usePrefixWhenEmpty && !this.useSuffixWhenEmpty) {
            return;
        }
        if (0 != itemCount || this.usePrefixWhenEmpty) {
            NaturalDescriptionJoiner.appendToDescription(desc, this.prefix);
        }
        int idx = itemCount - 1;
        for (DescriptionItem item : this.items) {
            NaturalDescriptionJoiner.appendToDescription(desc, item.valuePrefix);
            NaturalDescriptionJoiner.appendToDescription(desc, item.value);
            NaturalDescriptionJoiner.appendToDescription(desc, item.valueSuffix);
            if (1 == idx) {
                NaturalDescriptionJoiner.appendToDescription(desc, this.lastSeparator);
            } else if (idx > 1) {
                NaturalDescriptionJoiner.appendToDescription(desc, this.normalSeparator);
            }
            --idx;
        }
        if (0 != itemCount || this.useSuffixWhenEmpty) {
            NaturalDescriptionJoiner.appendToDescription(desc, this.suffix);
        }
    }

    public void appendTo(StringBuilder sb) {
        int itemCount = this.items.size();
        if (null == sb || 0 == itemCount && !this.usePrefixWhenEmpty && !this.useSuffixWhenEmpty) {
            return;
        }
        if (0 != itemCount || this.usePrefixWhenEmpty) {
            NaturalDescriptionJoiner.appendToStrBuilder(sb, this.prefix);
        }
        int idx = itemCount - 1;
        for (DescriptionItem item : this.items) {
            NaturalDescriptionJoiner.appendToStrBuilder(sb, item.valuePrefix);
            NaturalDescriptionJoiner.appendToStrBuilder(sb, item.value);
            NaturalDescriptionJoiner.appendToStrBuilder(sb, item.valueSuffix);
            if (1 == idx) {
                NaturalDescriptionJoiner.appendToStrBuilder(sb, this.lastSeparator);
            } else if (idx > 1) {
                NaturalDescriptionJoiner.appendToStrBuilder(sb, this.normalSeparator);
            }
            --idx;
        }
        if (0 != itemCount || this.useSuffixWhenEmpty) {
            NaturalDescriptionJoiner.appendToStrBuilder(sb, this.suffix);
        }
    }

    private static void appendToDescription(Description desc, Object obj) {
        if (obj instanceof SelfDescribing) {
            ((SelfDescribing)obj).describeTo(desc);
        } else if (null != obj) {
            desc.appendText(obj.toString());
        }
    }

    private static void appendToStrBuilder(StringBuilder sb, Object obj) {
        if (null != obj) {
            sb.append(obj);
        }
    }

    static final class DescriptionItem {
        final Object valuePrefix;
        final Object valueSuffix;
        final Object value;

        DescriptionItem(Object valuePrefix, Object value, Object valueSuffix) {
            this.valuePrefix = valuePrefix;
            this.value = value;
            this.valueSuffix = valueSuffix;
        }
    }
}

