/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class NaturalDescriptionJoiner
implements SelfDescribing {
    Object prefix;
    Object suffix;
    Object normalSeparator;
    Object lastSeparator;
    boolean usePrefixWhenEmpty;
    boolean useSuffixWhenEmpty;
    final List<DescriptionItem> items;

    public NaturalDescriptionJoiner(Object prefix, Object normalSeparator, Object lastSeparator, Object suffix) {
        this.prefix = prefix;
        this.normalSeparator = null != normalSeparator ? normalSeparator : "";
        this.lastSeparator = null != lastSeparator ? lastSeparator : "";
        this.suffix = suffix;
        this.items = new LinkedList<DescriptionItem>();
    }

    public NaturalDescriptionJoiner() {
        this(null, ", ", " and ", null);
    }

    public NaturalDescriptionJoiner(Object separator) {
        this(null, separator, separator, null);
    }

    public NaturalDescriptionJoiner(Object normalSeparator, Object lastSeparator) {
        this(null, normalSeparator, lastSeparator, null);
    }

    public NaturalDescriptionJoiner withPrefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public NaturalDescriptionJoiner withSuffix(Object suffix) {
        this.suffix = suffix;
        return this;
    }

    public NaturalDescriptionJoiner withNormalSeparator(Object normalSep) {
        this.normalSeparator = null != normalSep ? normalSep : "";
        return this;
    }

    public NaturalDescriptionJoiner withLastSeparator(Object lastSep) {
        this.lastSeparator = null != lastSep ? lastSep : "";
        return this;
    }

    public boolean isUsePrefixWhenEmpty() {
        return this.usePrefixWhenEmpty;
    }

    public void setUsePrefixWhenEmpty(boolean usePrefixWhenEmpty) {
        this.usePrefixWhenEmpty = usePrefixWhenEmpty;
    }

    public NaturalDescriptionJoiner withPrefixWhenEmpty() {
        this.usePrefixWhenEmpty = true;
        return this;
    }

    public NaturalDescriptionJoiner withoutPrefixWhenEmpty() {
        this.usePrefixWhenEmpty = false;
        return this;
    }

    public boolean isUseSuffixWhenEmpty() {
        return this.useSuffixWhenEmpty;
    }

    public void setUseSuffixWhenEmpty(boolean useSuffixWhenEmpty) {
        this.useSuffixWhenEmpty = useSuffixWhenEmpty;
    }

    public NaturalDescriptionJoiner withSuffixWhenEmpty() {
        this.useSuffixWhenEmpty = true;
        return this;
    }

    public NaturalDescriptionJoiner withoutSuffixWhenEmpty() {
        this.useSuffixWhenEmpty = false;
        return this;
    }

    public boolean isEmpty() {
        this.compactItems();
        return this.items.isEmpty();
    }

    public NaturalDescriptionJoiner add(Object valuePrefix, Object value, Object valueSuffix) {
        if (null != value) {
            DescriptionItem item = new DescriptionItem(valuePrefix, value, valueSuffix);
            this.items.add(item);
        }
        return this;
    }

    public void add(Object valuePrefix, Object value) {
        this.add(valuePrefix, value, null);
    }

    public void add(Object value) {
        this.add(null, value, null);
    }

    public <T> NaturalDescriptionJoiner addMismatch(Object valuePrefix, Matcher<? super T> valueMatcher, T value, Object valueSuffix) {
        if (null != valueMatcher && !valueMatcher.matches(value)) {
            DescriptionItem item = new DescriptionItem(valuePrefix, valueMatcher, value, valueSuffix);
            this.items.add(item);
        }
        return this;
    }

    public <T> void addMismatch(Object valuePrefix, Matcher<? super T> valueMatcher, T value) {
        this.addMismatch(valuePrefix, valueMatcher, value, null);
    }

    public <T> void addMismatch(Matcher<? super T> valueMatcher, T value) {
        this.addMismatch(null, valueMatcher, value, null);
    }

    public void describeTo(Description desc) {
        if (null == desc) {
            return;
        }
        this.compactItems();
        int itemCount = this.items.size();
        if (0 == itemCount && !this.usePrefixWhenEmpty && !this.useSuffixWhenEmpty) {
            return;
        }
        if (0 != itemCount || this.usePrefixWhenEmpty) {
            NaturalDescriptionJoiner.appendToDescription(desc, this.prefix);
        }
        int idx = itemCount - 1;
        for (DescriptionItem item : this.items) {
            NaturalDescriptionJoiner.appendToDescription(desc, item.valuePrefix);
            if (null != item.matcher) {
                item.matcher.describeMismatch(item.value, desc);
            } else {
                NaturalDescriptionJoiner.appendToDescription(desc, item.value);
            }
            NaturalDescriptionJoiner.appendToDescription(desc, item.valueSuffix);
            if (1 == idx) {
                NaturalDescriptionJoiner.appendToDescription(desc, this.lastSeparator);
            } else if (idx > 1) {
                NaturalDescriptionJoiner.appendToDescription(desc, this.normalSeparator);
            }
            --idx;
        }
        if (0 != itemCount || this.useSuffixWhenEmpty) {
            NaturalDescriptionJoiner.appendToDescription(desc, this.suffix);
        }
    }

    public void appendTo(StringBuilder sb) {
        if (null == sb) {
            return;
        }
        StringDescription desc = new StringDescription((Appendable)sb);
        this.describeTo((Description)desc);
    }

    private void compactItems() {
        Iterator<DescriptionItem> itemIterator = this.items.iterator();
        while (itemIterator.hasNext()) {
            DescriptionItem item = itemIterator.next();
            if (!item.isRedundant()) continue;
            itemIterator.remove();
        }
    }

    private static void appendToDescription(Description desc, Object obj) {
        if (obj instanceof SelfDescribing) {
            ((SelfDescribing)obj).describeTo(desc);
        } else if (null != obj) {
            desc.appendText(obj.toString());
        }
    }

    static final class DescriptionItem {
        final Object valuePrefix;
        final Object valueSuffix;
        final Object value;
        final Matcher<?> matcher;
        final boolean usingMatcher;

        DescriptionItem(Object valuePrefix, Object value, Object valueSuffix) {
            this.valuePrefix = valuePrefix;
            this.value = value;
            this.valueSuffix = valueSuffix;
            this.matcher = null;
            this.usingMatcher = false;
        }

        DescriptionItem(Object valuePrefix, Matcher<?> matcher, Object value, Object valueSuffix) {
            this.valuePrefix = valuePrefix;
            this.value = value;
            this.valueSuffix = valueSuffix;
            this.matcher = matcher;
            this.usingMatcher = true;
        }

        boolean isRedundant() {
            boolean result = this.usingMatcher ? null == this.matcher || this.matcher.matches(this.value) : null == this.value;
            return result;
        }
    }
}

