/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support.array;

import cz.auderis.test.support.array.ArrayItemFiller;
import cz.auderis.test.support.array.ArraySequenceParser;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;

public enum BuiltInItemSupport implements ArraySequenceParser,
ArrayItemFiller
{
    BIG_INTEGER((Class)BigInteger.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                while (scanner.hasNext()) {
                    BigInteger num = scanner.nextBigInteger();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse big integer values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            BigInteger value = new BigInteger(itemSpec);
            Array.set(target, index, value);
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                scanner.useLocale(Locale.US);
                while (scanner.hasNext()) {
                    BigDecimal num = scanner.nextBigDecimal();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse big decimal values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            BigDecimal value = new BigDecimal(itemSpec);
            Array.set(target, index, value);
        }
    };

    private final Class<?> itemType;

    private BuiltInItemSupport(Class<?> itemType) {
        this.itemType = itemType;
    }

    @Override
    public Class<?> getItemType() {
        return this.itemType;
    }

    public static BuiltInItemSupport forType(Class<?> itemType) {
        for (BuiltInItemSupport typeHandler : BuiltInItemSupport.values()) {
            if (itemType != typeHandler.itemType) continue;
            return typeHandler;
        }
        return null;
    }
}

