/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support.array;

import cz.auderis.test.support.array.ArraySequenceParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class MultiArraySupport {
    private static final Pattern DIMENSION_SPEC_SEPARATOR = Pattern.compile("\\s*[*xX]\\s*");

    public static ParserResult parseArraySpec(String arraySpec, ArraySequenceParser itemParser) {
        if (null == arraySpec || arraySpec.trim().isEmpty()) {
            return null;
        }
        int endOfDimensionPart = arraySpec.indexOf(58);
        if (endOfDimensionPart < 1) {
            throw new IllegalArgumentException("Invalid array specification: " + arraySpec);
        }
        String dimSpec = arraySpec.substring(0, endOfDimensionPart);
        int[] dimensions = MultiArraySupport.parseDimensions(dimSpec);
        int product = 1;
        int[] arr$ = dimensions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer dim = arr$[i$];
            product *= dim.intValue();
        }
        List<Object> items = endOfDimensionPart < arraySpec.length() - 1 ? itemParser.parseItems(arraySpec, endOfDimensionPart + 1, product) : Collections.emptyList();
        if (product != items.size()) {
            throw new IllegalArgumentException("Invalid array specification, expected " + product + " items: " + arraySpec);
        }
        return new ParserResult(dimensions, new LinkedList(items));
    }

    public static int[] parseDimensions(String dimSpec) {
        ArrayList<Integer> dimensions = new ArrayList<Integer>(4);
        Scanner scanner = new Scanner(dimSpec.trim());
        scanner.useDelimiter(DIMENSION_SPEC_SEPARATOR);
        while (scanner.hasNextInt()) {
            int dim = scanner.nextInt();
            if (dim < 0) {
                throw new IllegalArgumentException("Invalid array specification, negative dimension: " + dimSpec);
            }
            dimensions.add(dim);
        }
        if (dimensions.isEmpty()) {
            throw new IllegalArgumentException("Invalid array specification, cannot parseArraySpec dimensions: " + dimSpec);
        }
        int[] dimArray = new int[dimensions.size()];
        int i = 0;
        for (Integer dimension : dimensions) {
            dimArray[i] = dimension;
            ++i;
        }
        return dimArray;
    }

    private MultiArraySupport() {
        throw new AssertionError();
    }

    public static final class ParserResult {
        public final int[] dimensions;
        public final Queue<String> items;

        private ParserResult(int[] dimensions, Queue<String> items) {
            this.dimensions = dimensions;
            this.items = items;
        }
    }
}

