/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.slf4j;

import cz.auderis.test.logging.LogCaptureInitializer;
import cz.auderis.test.logging.slf4j.Slf4jLoggerFactory;
import java.lang.reflect.Field;

public class Slf4jInitializer
implements LogCaptureInitializer {
    private static boolean INITIALIZED = false;

    @Override
    public boolean isFrameworkPresent() {
        try {
            Class<?> frameworkClass = Class.forName("org.slf4j.LoggerFactory");
            assert (null != frameworkClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws Exception {
        Class<Slf4jInitializer> clazz = Slf4jInitializer.class;
        synchronized (Slf4jInitializer.class) {
            Field modifiersField;
            if (INITIALIZED) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot intercept SLF4J framework", e);
            }
            Slf4jLoggerFactory testLoggerFactory = new Slf4jLoggerFactory();
            try {
                Class<?> apiFactoryClass = Class.forName("org.slf4j.LoggerFactory");
                Field factoryField = apiFactoryClass.getDeclaredField("NOP_FALLBACK_FACTORY");
                factoryField.setAccessible(true);
                modifiersField.setInt(factoryField, factoryField.getModifiers() & 0xFFFFFFEF);
                factoryField.set(null, (Object)testLoggerFactory);
                Field fallbackField = apiFactoryClass.getDeclaredField("NOP_FALLBACK_INITIALIZATION");
                fallbackField.setAccessible(true);
                int fallbackStateValue = fallbackField.getInt(null);
                Field stateField = apiFactoryClass.getDeclaredField("INITIALIZATION_STATE");
                stateField.setAccessible(true);
                modifiersField.setInt(stateField, stateField.getModifiers() & 0xFFFFFFEF);
                stateField.setInt(null, fallbackStateValue);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("SLF4J framework not detected");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Unsupported SLF4J framework API version");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to intercept SLF4J provider", e);
            }
            finally {
                INITIALIZED = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

