/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher;

import cz.auderis.test.matcher.PropertyExtractor;
import cz.auderis.test.support.DescriptionProvider;
import cz.auderis.test.support.MismatchDescriptionProvider;
import cz.auderis.test.support.NaturalDescriptionJoiner;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MultiPropertyMatcher<T>
extends TypeSafeMatcher<T> {
    final List<PropMatcherEntry> entries = new LinkedList<PropMatcherEntry>();
    final String objectName;
    Callable<NaturalDescriptionJoiner> joinerProvider;
    Callable<NaturalDescriptionJoiner> mismatchJoinerProvider;

    public MultiPropertyMatcher(Class<T> matchedTypeClass, String objectName) {
        this(matchedTypeClass, objectName, null, null);
    }

    public MultiPropertyMatcher(Class<T> matchedTypeClass, String objectName, Callable<NaturalDescriptionJoiner> joinerProvider, Callable<NaturalDescriptionJoiner> mismatchJoinerProvider) {
        super(matchedTypeClass);
        this.objectName = null != objectName ? objectName : matchedTypeClass.getSimpleName();
        this.joinerProvider = joinerProvider;
        this.mismatchJoinerProvider = mismatchJoinerProvider;
    }

    public <P> PropertyEntry addProperty(Object propertyName, Matcher<? super P> propertyMatcher, PropertyExtractor<T, P> propertyExtractor) {
        if (null == propertyMatcher || null == propertyExtractor) {
            return DummyPropertyEntry.INSTANCE;
        }
        PropMatcherEntry entry = new PropMatcherEntry(propertyMatcher, propertyExtractor, propertyName, null);
        this.entries.add(entry);
        return entry;
    }

    public void setJoinerProvider(Callable<NaturalDescriptionJoiner> joinerProvider) {
        this.joinerProvider = joinerProvider;
    }

    public void setMismatchJoinerProvider(Callable<NaturalDescriptionJoiner> mismatchJoinerProvider) {
        this.mismatchJoinerProvider = mismatchJoinerProvider;
    }

    protected boolean matchesSafely(T obj) {
        for (PropMatcherEntry entry : this.entries) {
            if (entry.matches(obj)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        NaturalDescriptionJoiner joiner;
        description.appendText(this.objectName);
        if (null == this.joinerProvider) {
            joiner = new NaturalDescriptionJoiner(" with ", ", ", " and ", null);
        } else {
            try {
                joiner = this.joinerProvider.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot describe object " + this.objectName, e);
            }
        }
        for (PropMatcherEntry entry : this.entries) {
            entry.addToJoiner(joiner);
        }
        joiner.describeTo(description);
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        NaturalDescriptionJoiner joiner;
        if (null == this.mismatchJoinerProvider) {
            joiner = new NaturalDescriptionJoiner(", ", " and ");
        } else {
            try {
                joiner = this.mismatchJoinerProvider.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot describe mismatch of object " + this.objectName, e);
            }
        }
        for (PropMatcherEntry entry : this.entries) {
            entry.addMismatchToJoiner(item, joiner);
        }
        joiner.describeTo(mismatchDescription);
    }

    static enum DummyPropertyEntry implements PropertyEntry
    {
        INSTANCE{

            @Override
            public PropertyEntry withPrefix(Object prefix) {
                return this;
            }

            @Override
            public PropertyEntry withSuffix(Object suffix) {
                return this;
            }

            @Override
            public PropertyEntry withMatcherDescriber(DescriptionProvider<Matcher<?>> describer) {
                return this;
            }

            @Override
            public PropertyEntry withMismatchDescriber(MismatchDescriptionProvider<?> describer) {
                return this;
            }
        };

    }

    static final class PropMatcherEntry
    implements PropertyEntry {
        final Matcher<Object> matcher;
        final PropertyExtractor extractor;
        Object descPrefix;
        Object descSuffix;
        DescriptionProvider<Matcher<?>> valueDescriber;
        MismatchDescriptionProvider<Object> mismatchDescriber;

        PropMatcherEntry(Matcher<Object> matcher, PropertyExtractor extractor, Object descPrefix, Object descSuffix) {
            assert (null != matcher);
            assert (null != extractor);
            this.matcher = matcher;
            this.extractor = extractor;
            this.descPrefix = descPrefix;
            this.descSuffix = descSuffix;
        }

        @Override
        public PropertyEntry withPrefix(Object prefix) {
            this.descPrefix = prefix;
            return this;
        }

        @Override
        public PropertyEntry withSuffix(Object suffix) {
            this.descSuffix = suffix;
            return this;
        }

        @Override
        public PropertyEntry withMatcherDescriber(DescriptionProvider<Matcher<?>> describer) {
            this.valueDescriber = describer;
            return this;
        }

        @Override
        public PropertyEntry withMismatchDescriber(MismatchDescriptionProvider<?> describer) {
            this.mismatchDescriber = describer;
            return this;
        }

        boolean matches(Object obj) {
            Object property = this.extractor.extract(obj);
            return this.matcher.matches(property);
        }

        void addToJoiner(NaturalDescriptionJoiner joiner) {
            joiner.add(this.descPrefix, this.matcher, this.descSuffix, this.valueDescriber);
        }

        void addMismatchToJoiner(Object obj, NaturalDescriptionJoiner joiner) {
            Object property = this.extractor.extract(obj);
            if (!this.matcher.matches(property)) {
                joiner.addMismatch(this.descPrefix, this.matcher, property, this.descSuffix, this.mismatchDescriber);
            }
        }
    }

    public static interface PropertyEntry {
        public PropertyEntry withPrefix(Object var1);

        public PropertyEntry withSuffix(Object var1);

        public PropertyEntry withMatcherDescriber(DescriptionProvider<Matcher<?>> var1);

        public PropertyEntry withMismatchDescriber(MismatchDescriptionProvider<?> var1);
    }
}

