/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.rawarray;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IsByteArrayContainingMatcher
extends TypeSafeMatcher<byte[]> {
    private final byte[] expectedData;

    public IsByteArrayContainingMatcher(byte[] expectedData) {
        super(byte[].class);
        if (null == expectedData) {
            throw new NullPointerException();
        }
        this.expectedData = 0 == expectedData.length ? expectedData : Arrays.copyOf(expectedData, expectedData.length);
    }

    public IsByteArrayContainingMatcher(int ... intValues) {
        super(byte[].class);
        this.expectedData = new byte[intValues.length];
        for (int i = 0; i < intValues.length; ++i) {
            this.expectedData[i] = (byte)intValues[i];
        }
    }

    protected boolean matchesSafely(byte[] bytes) {
        return Arrays.equals(bytes, this.expectedData);
    }

    public void describeTo(Description description) {
        if (0 == this.expectedData.length) {
            description.appendText("empty byte array");
        } else {
            description.appendText("byte array of size " + this.expectedData.length);
            description.appendText(" containing ");
            description.appendText(IsByteArrayContainingMatcher.formatByteArray(this.expectedData, null).toString());
        }
    }

    protected void describeMismatchSafely(byte[] bytes, Description out) {
        int size = bytes.length;
        if (size != this.expectedData.length) {
            out.appendText("data size was " + size);
        } else {
            out.appendText("was ").appendText(IsByteArrayContainingMatcher.formatByteArray(bytes, this.expectedData).toString());
        }
    }

    static StringBuilder formatByteArray(byte[] data, byte[] reference) {
        if (null != reference && reference.length != data.length) {
            reference = null;
        }
        StringBuilder str = new StringBuilder(4 * data.length + 1);
        str.append('<');
        char separator = '\u0000';
        for (int i = 0; i < data.length; ++i) {
            if ('\u0000' == separator) {
                separator = ' ';
            } else {
                str.append(separator);
            }
            if (null != reference && data[i] != reference[i]) {
                str.append('*');
            }
            int byteValue = 0xFF & data[i];
            str.append(Character.toUpperCase(Character.forDigit(byteValue >>> 4, 16)));
            str.append(Character.toUpperCase(Character.forDigit(byteValue & 0xF, 16)));
        }
        str.append('>');
        return str;
    }
}

