/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.text;

import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class SuffixMatcher<T extends CharSequence>
extends TypeSafeMatcher<T> {
    private static final char[][] BRACKET_CANDIDATES = new char[][]{{'<', '>'}, {'[', ']'}, {'\u27ea', '\u27eb'}};
    private final String suffix;
    private final int suffixLength;
    private final boolean caseSensitive;

    SuffixMatcher(String suffix, boolean caseSensitive) {
        super(CharSequence.class);
        if (null == suffix) {
            throw new NullPointerException();
        }
        this.suffix = suffix;
        this.suffixLength = suffix.length();
        this.caseSensitive = caseSensitive;
    }

    protected boolean matchesSafely(CharSequence testedText) {
        int matchLength = this.commonSuffixLength(testedText);
        return this.suffixLength == matchLength;
    }

    private int commonSuffixLength(CharSequence testedText) {
        int resultMultiplier;
        int len;
        int textLen = testedText.length();
        if (textLen >= this.suffixLength) {
            len = this.suffixLength;
            resultMultiplier = 1;
        } else {
            len = textLen;
            resultMultiplier = -1;
        }
        for (int i = 0; i < len; ++i) {
            char suffixCharLC;
            char testedCharLC;
            char suffixCharUC;
            char suffixChar;
            char testedChar = testedText.charAt(textLen - 1 - i);
            if (testedChar == (suffixChar = this.suffix.charAt(this.suffixLength - 1 - i))) continue;
            if (this.caseSensitive) {
                return resultMultiplier * i;
            }
            char testedCharUC = Character.toUpperCase(testedChar);
            if (testedCharUC == (suffixCharUC = Character.toUpperCase(suffixChar)) || (testedCharLC = Character.toLowerCase(testedChar)) == (suffixCharLC = Character.toLowerCase(suffixChar))) continue;
            return resultMultiplier * i;
        }
        return resultMultiplier * len;
    }

    public void describeTo(Description desc) {
        desc.appendText("ending with ");
        if (!this.caseSensitive && this.suffixLength > 0) {
            desc.appendText("(case insensitive) ");
        }
        desc.appendValue((Object)this.suffix);
    }

    protected void describeMismatchSafely(CharSequence testedText, Description desc) {
        desc.appendText("was ");
        int matchLength = this.commonSuffixLength(testedText);
        assert (matchLength < this.suffixLength);
        int textLength = testedText.length();
        if (0 == matchLength) {
            desc.appendValue((Object)testedText);
        } else if (-matchLength == textLength) {
            assert (textLength < this.suffixLength);
            desc.appendValue((Object)testedText);
            desc.appendText(", short by ").appendText(Integer.toString(this.suffixLength - textLength)).appendText(" characters");
        } else if (matchLength > 0) {
            String[] bracket = SuffixMatcher.selectBracket(testedText);
            StringBuilder str = new StringBuilder(textLength + bracket[0].length() + bracket[1].length());
            for (int i = 0; i < textLength; ++i) {
                if (i == textLength - this.suffixLength) {
                    str.append(bracket[0]);
                } else if (i == textLength - matchLength) {
                    str.append(bracket[1]);
                }
                str.append(testedText.charAt(i));
            }
            desc.appendValue((Object)str.toString());
            desc.appendText(", with last ").appendText(Integer.toString(matchLength)).appendText(" characters matching");
        } else {
            String[] bracket = SuffixMatcher.selectBracket(testedText);
            StringBuilder str = new StringBuilder(textLength + bracket[0].length() + bracket[1].length());
            str.append(bracket[0]);
            for (int i = 0; i < textLength; ++i) {
                if (i == textLength + matchLength) {
                    str.append(bracket[1]);
                }
                str.append(testedText.charAt(i));
            }
            desc.appendValue((Object)str.toString());
            desc.appendText(", short by ").appendText(Integer.toString(this.suffixLength - textLength)).appendText(" characters");
            desc.appendText(" and with last ").appendText(Integer.toString(-matchLength)).appendText(" characters matching");
        }
    }

    private static String[] selectBracket(CharSequence testedText) {
        HashSet<Character> availableBracketChars = new HashSet<Character>(2 * BRACKET_CANDIDATES.length);
        for (char[] bracketCandidate : BRACKET_CANDIDATES) {
            availableBracketChars.add(Character.valueOf(bracketCandidate[0]));
            availableBracketChars.add(Character.valueOf(bracketCandidate[1]));
        }
        int length = testedText.length();
        for (int i = 0; i < length; ++i) {
            availableBracketChars.remove(Character.valueOf(testedText.charAt(i)));
        }
        String[] result = new String[2];
        for (char[] bracketCandidate : BRACKET_CANDIDATES) {
            char c1 = bracketCandidate[0];
            char c2 = bracketCandidate[1];
            if (!availableBracketChars.contains(Character.valueOf(c1)) || !availableBracketChars.contains(Character.valueOf(c2))) continue;
            result[0] = Character.toString(c1);
            result[1] = Character.toString(c2);
            return result;
        }
        result[0] = " << ";
        result[1] = " >> ";
        return result;
    }
}

