/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import cz.auderis.test.parameter.annotation.HexBuffer;
import cz.auderis.test.parameter.annotation.impl.HexChunkParser;
import java.nio.ByteBuffer;
import junitparams.converters.ConversionFailedException;
import junitparams.converters.Converter;

public class HexBufferAnnotationConverter
implements Converter<HexBuffer, ByteBuffer> {
    private boolean useDirectBuffer;
    private boolean skipRewind;
    private int capacity;

    public void initialize(HexBuffer annotation) {
        this.useDirectBuffer = annotation.direct();
        this.skipRewind = !annotation.rewind();
        this.capacity = annotation.capacity();
    }

    public ByteBuffer convert(Object param) throws ConversionFailedException {
        ByteBuffer result;
        HexChunkParser parser = new HexChunkParser(this.useDirectBuffer);
        ByteBuffer baseBuffer = parser.parseBuffer(param);
        if (this.capacity <= 0 || this.capacity == baseBuffer.capacity()) {
            result = baseBuffer;
            if (this.skipRewind) {
                result.position(result.limit());
            }
        } else if (this.capacity < baseBuffer.capacity()) {
            baseBuffer.limit(this.capacity);
            result = baseBuffer.slice();
            if (this.skipRewind) {
                result.position(result.limit());
            }
        } else {
            result = this.useDirectBuffer ? ByteBuffer.allocateDirect(this.capacity) : ByteBuffer.allocate(this.capacity);
            result.put(baseBuffer);
            if (!this.skipRewind) {
                result.rewind();
            }
        }
        return result;
    }
}

