/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support.array;

import cz.auderis.test.support.array.ArraySequenceParser;
import java.util.ArrayList;
import java.util.List;

public enum BasicArraySequenceParsers implements ArraySequenceParser
{
    TOKENS{

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            StringBuilder str = new StringBuilder(sourceText.length());
            boolean skippingMandatoryWhitespace = false;
            boolean skippingOptionalWhitespace = true;
            char currentQuote = '\u0000';
            boolean escapeActive = false;
            for (int offset = initialOffset; offset < sourceText.length(); ++offset) {
                boolean isQuote;
                char c = sourceText.charAt(offset);
                boolean isWhitespace = Character.isWhitespace(c);
                boolean bl = isQuote = '\'' == c || '\"' == c;
                if (skippingMandatoryWhitespace) {
                    assert (0 == str.length());
                    if (!isWhitespace) {
                        throw new IllegalArgumentException("Invalid array specification, missing item separator: " + sourceText);
                    }
                    skippingOptionalWhitespace = true;
                    skippingMandatoryWhitespace = false;
                    continue;
                }
                if (skippingOptionalWhitespace) {
                    assert (0 == str.length());
                    if (isWhitespace) continue;
                    skippingOptionalWhitespace = false;
                    if (isQuote) {
                        currentQuote = c;
                        continue;
                    }
                    str.append(c);
                    continue;
                }
                if ('\u0000' == currentQuote) {
                    if (isWhitespace) {
                        result.add(str.toString());
                        str.setLength(0);
                        skippingOptionalWhitespace = true;
                        continue;
                    }
                    if ('\\' == c) {
                        throw new IllegalArgumentException("Invalid array specification, escape not allowed in unquoted token: " + sourceText);
                    }
                    if (isQuote) {
                        throw new IllegalArgumentException("Invalid array specification, quote not allowed in unquoted token: " + sourceText);
                    }
                    str.append(c);
                    continue;
                }
                if (escapeActive) {
                    if (currentQuote != c && '\\' != c) {
                        str.append('\\');
                    }
                    str.append(c);
                    escapeActive = false;
                    continue;
                }
                if ('\\' == c) {
                    escapeActive = true;
                    continue;
                }
                if (c == currentQuote) {
                    result.add(str.toString());
                    str.setLength(0);
                    currentQuote = '\u0000';
                    skippingMandatoryWhitespace = true;
                    continue;
                }
                str.append(c);
            }
            assert ((skippingMandatoryWhitespace || skippingOptionalWhitespace) == (0 == str.length()));
            if (str.length() > 0) {
                if (escapeActive) {
                    throw new IllegalArgumentException("Invalid array specification, unfinished escape sequence: " + sourceText);
                }
                if ('\u0000' != currentQuote) {
                    throw new IllegalArgumentException("Invalid array specification, missing terminating quote " + currentQuote + ": " + sourceText);
                }
                result.add(str.toString());
            }
            return result;
        }
    };

}

