/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.log4j;

import cz.auderis.test.logging.LogCaptureInitializer;
import cz.auderis.test.logging.log4j.Log4jRepositorySelector;
import java.lang.reflect.Field;

public class Log4jInitializer
implements LogCaptureInitializer {
    private static boolean INITIALIZED = false;

    @Override
    public boolean isFrameworkPresent() {
        try {
            Class<?> frameworkClass = Class.forName("org.apache.log4j.LogManager");
            assert (null != frameworkClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws Exception {
        Class<Log4jInitializer> clazz = Log4jInitializer.class;
        synchronized (Log4jInitializer.class) {
            if (INITIALIZED) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                Class<?> managerClass = Class.forName("org.apache.log4j.LogManager");
                Field selectorField = managerClass.getDeclaredField("repositorySelector");
                selectorField.setAccessible(true);
                selectorField.set(null, Log4jRepositorySelector.INSTANCE);
                Field guardField = managerClass.getDeclaredField("guard");
                guardField.setAccessible(true);
                guardField.set(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Log4J framework not detected");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Unsupported version of Log4J framework");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to intercept Log4J manager", e);
            }
            finally {
                INITIALIZED = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

