/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.rawarray;

import cz.auderis.test.matcher.rawarray.IsByteArrayContainingMatcher;
import cz.auderis.test.matcher.rawarray.IsByteBufferContainingMatcher;
import java.nio.ByteBuffer;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public final class RawArrayMatchers {
    @Factory
    public static <T> Matcher<byte[]> byteArrayContaining(byte ... bytes) {
        return new IsByteArrayContainingMatcher(bytes);
    }

    @Factory
    public static <T> Matcher<byte[]> byteArrayContaining(int ... byteValues) {
        return new IsByteArrayContainingMatcher(byteValues);
    }

    @Factory
    public static <T> Matcher<ByteBuffer> containsBytes(byte[] bytes) {
        return new IsByteBufferContainingMatcher(bytes);
    }

    @Factory
    public static <T> Matcher<ByteBuffer> containsBytes(int ... byteValues) {
        return new IsByteBufferContainingMatcher(byteValues);
    }

    @Factory
    public static <T> Matcher<ByteBuffer> hasSameContentsAs(ByteBuffer reference) {
        return new IsByteBufferContainingMatcher(reference);
    }

    private RawArrayMatchers() {
        throw new AssertionError();
    }
}

