/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IntegerMatcher
extends TypeSafeMatcher<Number> {
    private static final Set<Class<?>> SYSTEM_INTEGER_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, BigInteger.class, AtomicInteger.class, AtomicLong.class)));

    public IntegerMatcher() {
        super(Number.class);
    }

    protected boolean matchesSafely(Number num) {
        BigDecimal decNum;
        boolean isInteger = SYSTEM_INTEGER_CLASSES.contains(num.getClass()) ? true : (num instanceof BigDecimal ? (decNum = (BigDecimal)num).stripTrailingZeros().scale() <= 0 : false);
        return isInteger;
    }

    public void describeTo(Description description) {
        description.appendText("integer value");
    }

    protected void describeMismatchSafely(Number num, Description out) {
        out.appendText("was ");
        if (num instanceof BigDecimal) {
            BigDecimal decNum = (BigDecimal)num;
            out.appendValue((Object)decNum.toPlainString());
            out.appendText(" with decimal scale " + decNum.scale());
        } else {
            out.appendText("unsupported type " + num.getClass() + " with value ");
            out.appendValue((Object)num);
        }
    }
}

