/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import cz.auderis.test.parameter.annotation.UsingPropertyEditor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import junitparams.converters.ConversionFailedException;
import junitparams.converters.Converter;

public class PropertyEditorAnnotationConverter
implements Converter<UsingPropertyEditor, Object> {
    Class<?> targetType;
    PropertyEditor editor;

    public void initialize(UsingPropertyEditor annotation) {
        Class<?> targetType = PropertyEditorAnnotationConverter.optionalClass(annotation.of());
        Class<?> editorClass = PropertyEditorAnnotationConverter.optionalClass(annotation.editor());
        if (null == targetType && null == editorClass) {
            throw new IllegalArgumentException("Property editor not specified");
        }
        if (null == editorClass) {
            this.editor = PropertyEditorManager.findEditor(targetType);
            if (null == this.editor) {
                throw new IllegalArgumentException("Property editor for type " + targetType + " not found");
            }
        } else {
            if (!PropertyEditor.class.isAssignableFrom(editorClass)) {
                throw new IllegalArgumentException("Invalid property editor type: " + editorClass);
            }
            try {
                Object editorObject = editorClass.newInstance();
                this.editor = (PropertyEditor)editorObject;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot create property editor instance: " + editorClass, e);
            }
        }
        this.targetType = targetType;
    }

    public Object convert(Object param) throws ConversionFailedException {
        try {
            String paramString = PropertyEditorAnnotationConverter.asString(param);
            this.editor.setAsText(paramString);
            Object result = this.editor.getValue();
            return result;
        }
        catch (Exception e) {
            ConversionFailedException e2 = new ConversionFailedException("Cannot convert value '" + param + "' using " + this.editor.toString());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    static Class<?> optionalClass(Class<?> cls) {
        if (null == cls || cls == Void.class) {
            return null;
        }
        return cls;
    }

    static String asString(Object param) {
        String paramString = null == param ? null : (param instanceof String ? (String)param : param.toString());
        return paramString;
    }
}

