/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.log4j;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogRecordCollector;
import cz.auderis.test.logging.log4j.Log4jLoggerAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;

class Log4jLoggerRepository
implements LoggerRepository {
    public static final Map<LogLevel, Level> INTERNAL_TO_LOG4J = Log4jLoggerRepository.prepareLevelMap();
    static final Log4jLoggerRepository INSTANCE = new Log4jLoggerRepository();
    private static final ConcurrentMap<String, Log4jLoggerAdapter> LOGGERS = new ConcurrentHashMap<String, Log4jLoggerAdapter>(16);
    private static final String ROOT_LOGGER_NAME = "";

    private static Map<LogLevel, Level> prepareLevelMap() {
        EnumMap<LogLevel, Level> levelMap = new EnumMap<LogLevel, Level>(LogLevel.class);
        levelMap.put(LogLevel.TRACE, Level.TRACE);
        levelMap.put(LogLevel.DEBUG, Level.DEBUG);
        levelMap.put(LogLevel.INFO, Level.INFO);
        levelMap.put(LogLevel.WARNING, Level.WARN);
        levelMap.put(LogLevel.ERROR, Level.ERROR);
        levelMap.put(LogLevel.FATAL, Level.FATAL);
        return Collections.unmodifiableMap(levelMap);
    }

    Log4jLoggerRepository() {
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)LOGGERS.get(name);
        if (null == logger) {
            Log4jLoggerAdapter newLogger = new Log4jLoggerAdapter(name);
            Log4jLoggerAdapter origLogger = LOGGERS.putIfAbsent(name, newLogger);
            logger = null != origLogger ? origLogger : newLogger;
        }
        return logger;
    }

    public Logger getLogger(String name, LoggerFactory factory) {
        return this.getLogger(name);
    }

    public Logger exists(String name) {
        return (Logger)LOGGERS.get(name);
    }

    public Logger getRootLogger() {
        return this.getLogger(ROOT_LOGGER_NAME);
    }

    public Enumeration getCurrentLoggers() {
        Set loggerNames = LOGGERS.keySet();
        loggerNames.remove(ROOT_LOGGER_NAME);
        if (loggerNames.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        ArrayList<Log4jLoggerAdapter> loggerInstances = new ArrayList<Log4jLoggerAdapter>(loggerNames.size());
        for (String loggerName : loggerNames) {
            Log4jLoggerAdapter instance = (Log4jLoggerAdapter)((Object)LOGGERS.get(loggerName));
            if (null == instance) continue;
            loggerInstances.add(instance);
        }
        return Collections.enumeration(loggerInstances);
    }

    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    public void resetConfiguration() {
    }

    public void emitNoAppenderWarning(Category cat) {
    }

    public void shutdown() {
    }

    public void setThreshold(String levelStr) {
        Level level = Level.toLevel((String)levelStr, null);
        assert (null != level) : "Invalid Log4J level: " + levelStr;
        LogLevel internalLevel = Log4jLoggerAdapter.LOG4J_TO_INTERNAL.get(level);
        assert (null != internalLevel);
        LogRecordCollector.RECORD_COLLECTOR.setEnabledLevels(internalLevel.plusHigherLevels());
    }

    public void setThreshold(Level level) {
        LogLevel internalLevel = Log4jLoggerAdapter.LOG4J_TO_INTERNAL.get(level);
        assert (null != internalLevel);
        LogRecordCollector.RECORD_COLLECTOR.setEnabledLevels(internalLevel.plusHigherLevels());
    }

    public Level getThreshold() {
        Set<LogLevel> enabledLevels = LogRecordCollector.RECORD_COLLECTOR.getEnabledLevels();
        LogLevel threshold = LogLevel.lowestLevel(enabledLevels);
        return INTERNAL_TO_LOG4J.get((Object)threshold);
    }

    public boolean isDisabled(int level) {
        return this.getThreshold().toInt() > level;
    }

    public void addHierarchyEventListener(HierarchyEventListener listener) {
    }

    public void fireAddAppenderEvent(Category logger, Appender appender) {
    }
}

