/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.date;

import cz.auderis.test.matcher.date.CalendarMatcherAdapter;
import cz.auderis.test.matcher.date.DateHelper;
import cz.auderis.test.matcher.date.DateRangeMatcher;
import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public final class CalendarMatchers {
    @Factory
    public static <T> Matcher<Calendar> today() {
        Date now = new Date();
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(now, now, 5, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> thisMonth() {
        Date now = new Date();
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(now, now, 2, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> thisYear() {
        Date now = new Date();
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(now, now, 1, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> sameDayAs(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, refDate, 5, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> sameMonthAs(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, refDate, 2, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> sameYearAs(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, refDate, 1, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> sameDayAs(String dateText) {
        Date refDate = DateHelper.parseDate(dateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, refDate, 5, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> sameMonthAs(String dateText) {
        Date refDate = DateHelper.parseDate(dateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, refDate, 2, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> sameYearAs(String dateText) {
        Date refDate = DateHelper.parseDate(dateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, refDate, 1, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> beforeDate(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(null, refDate, 5, true, false));
    }

    @Factory
    public static <T> Matcher<Calendar> beforeDate(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(null, refDate, 5, true, false));
    }

    @Factory
    public static <T> Matcher<Calendar> before(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(null, refDate, 14, true, false));
    }

    @Factory
    public static <T> Matcher<Calendar> before(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(null, refDate, 14, true, false));
    }

    @Factory
    public static <T> Matcher<Calendar> afterDate(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, null, 5, false, true));
    }

    @Factory
    public static <T> Matcher<Calendar> afterDate(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, null, 5, false, true));
    }

    @Factory
    public static <T> Matcher<Calendar> after(Date refDate) {
        if (null == refDate) {
            throw new NullPointerException();
        }
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, null, 14, false, true));
    }

    @Factory
    public static <T> Matcher<Calendar> after(String refDateText) {
        Date refDate = DateHelper.parseDate(refDateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(refDate, null, 14, false, true));
    }

    @Factory
    public static <T> Matcher<Calendar> betweenDates(Date startDate, Date endDate) {
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(startDate, endDate, 5, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> betweenDates(String startDateText, String endDateText) {
        Date startDate = DateHelper.parseDateAllowingNull(startDateText);
        Date endDate = DateHelper.parseDateAllowingNull(endDateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(startDate, endDate, 5, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> between(Date startDate, Date endDate) {
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(startDate, endDate, 14, true, true));
    }

    @Factory
    public static <T> Matcher<Calendar> between(String startDateText, String endDateText) {
        Date startDate = DateHelper.parseDateAllowingNull(startDateText);
        Date endDate = DateHelper.parseDateAllowingNull(endDateText);
        return CalendarMatchers.forCalendar((Matcher<Date>)new DateRangeMatcher(startDate, endDate, 14, true, true));
    }

    private CalendarMatchers() {
        throw new AssertionError();
    }

    private static Matcher<Calendar> forCalendar(Matcher<Date> dateMatcher) {
        return new CalendarMatcherAdapter(dateMatcher);
    }
}

