/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.text;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class SimpleCharPatternMatcher
extends TypeSafeMatcher<CharSequence> {
    private final CharSequencePattern pattern;

    public SimpleCharPatternMatcher(CharSequencePattern pattern) {
        super(CharSequence.class);
        assert (null != pattern);
        this.pattern = pattern;
    }

    protected boolean matchesSafely(CharSequence seq) {
        if (seq.length() < 1) {
            return false;
        }
        if (this.pattern.isValidStartChar(seq.charAt(0))) {
            return false;
        }
        for (int i = 1; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (this.pattern.isValidChar(c)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.pattern.toString());
    }

    protected void describeMismatchSafely(CharSequence seq, Description out) {
        if (seq.length() < 1) {
            out.appendText("was empty");
        } else {
            int badStart = -1;
            if (!this.pattern.isValidStartChar(seq.charAt(0))) {
                badStart = 0;
            } else {
                for (int i = 1; i < seq.length(); ++i) {
                    char c = seq.charAt(i);
                    if (this.pattern.isValidChar(c)) continue;
                    badStart = i;
                    break;
                }
            }
            assert (badStart >= 0);
            int badEnd = -1;
            for (int i = badStart + 1; i < seq.length(); ++i) {
                char c = seq.charAt(i);
                if (!this.pattern.isValidChar(c)) continue;
                badEnd = i;
                break;
            }
            assert (badEnd >= 1);
            out.appendValue((Object)seq);
            if (0 == badStart) {
                out.appendText(" has invalid prefix ");
            } else {
                out.appendText(" contains invalid part ");
            }
            out.appendValue((Object)seq.subSequence(badStart, badEnd));
        }
    }

    public static interface CharSequencePattern {
        public boolean isValidStartChar(char var1);

        public boolean isValidChar(char var1);
    }
}

